/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class NewUserPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "NewUserPlugin";

    public NewUserPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Profile profile = (Profile)ctx.value(SocialNotificationUtils.PROFILE);
        String remoteId = profile.getIdentity().getRemoteId();
        try {
            UserSettingService userSettingService = (UserSettingService)CommonsUtils.getService(UserSettingService.class);
            userSettingService.addMixin(remoteId);
            return NotificationInfo.instance().key(this.getId()).with(SocialNotificationUtils.REMOTE_ID.getKey(), remoteId).setSendAll(true).setFrom(remoteId).end();
        }
        catch (Exception e) {
            return null;
        }
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        String remoteId = notification.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
        Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
        Profile userProfile = identity.getProfile();
        templateContext.put((Object)"USER", (Object)userProfile.getFullName());
        templateContext.put((Object)"PORTAL_NAME", (Object)NotificationPluginUtils.getBrandingPortalName());
        templateContext.put((Object)"PORTAL_HOME", (Object)NotificationPluginUtils.getPortalHome((String)NotificationPluginUtils.getBrandingPortalName()));
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(userProfile));
        templateContext.put((Object)"CONNECT_ACTION_URL", (Object)LinkProviderUtils.getInviteToConnectUrl(identity.getRemoteId(), notification.getTo()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        int count = notifications.size();
        String[] keys = new String[]{"USER", "USER_LIST", "LAST3_USERS"};
        String key = "";
        StringBuilder value = new StringBuilder();
        try {
            writer.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
            for (int i = 0; i < count && i < 3; ++i) {
                String remoteId = ((NotificationInfo)notifications.get(i)).getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
                Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
                key = i > 1 && count == 3 ? keys[i - 1] : keys[i];
                value.append(SocialNotificationUtils.buildRedirecUrl("user", identity.getRemoteId(), identity.getProfile().getFullName()));
                if (count <= i + 1 || i >= 2) continue;
                value.append(", ");
            }
            templateContext.put((Object)key, (Object)value.toString());
            if (count > 3) {
                templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl("connections", first.getTo(), String.valueOf(count - 3)));
            }
            String portalName = System.getProperty("exo.notifications.portalname", "eXo");
            String portalLink = SocialNotificationUtils.buildRedirecUrl("portal_home", portalName, portalName);
            templateContext.put((Object)"PORTAL_NAME", (Object)portalName);
            templateContext.put((Object)"PORTAL_HOME", (Object)portalLink);
            String digester = TemplateUtils.processDigest((TemplateContext)templateContext.digestType(count));
            writer.append(digester);
            writer.append("</li>");
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }
}

