/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class PostActivityPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "PostActivityPlugin";

    public PostActivityPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        try {
            ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
            return NotificationInfo.instance().to(activity.getStreamOwner()).with(SocialNotificationUtils.POSTER.getKey(), Utils.getUserId(activity.getPosterId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).key(this.getId()).end();
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
        Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
        templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
        templateContext.put((Object)"SUBJECT", (Object)activity.getTitle());
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"ACTIVITY", (Object)activity.getTitle());
        templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activity.getId()));
        templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activity.getId()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String sendToUser = first.getTo();
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo message : notifications) {
                SocialNotificationUtils.processInforSendTo(receiverMap, sendToUser, message.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey()));
            }
            writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext, "user"));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        return !activity.getStreamOwner().equals(Utils.getUserId(activity.getPosterId())) && !Utils.isSpaceActivity(activity);
    }
}

