/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class PostActivitySpaceStreamPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "PostActivitySpaceStreamPlugin";

    public PostActivitySpaceStreamPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        try {
            ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
            Space space = Utils.getSpaceService().getSpaceByPrettyName(activity.getStreamOwner());
            String poster = Utils.getUserId(activity.getPosterId());
            return NotificationInfo.instance().key(this.getId()).with(SocialNotificationUtils.POSTER.getKey(), poster).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).to(Utils.getDestinataires(activity, space)).end();
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
        Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), true);
        templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
        templateContext.put((Object)"SPACE", (Object)spaceIdentity.getProfile().getFullName());
        templateContext.put((Object)"ACTIVITY", (Object)activity.getTitle());
        templateContext.put((Object)"SUBJECT", (Object)activity.getTitle());
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        Space space = Utils.getSpaceService().getSpaceByPrettyName(spaceIdentity.getRemoteId());
        templateContext.put((Object)"SPACE_URL", (Object)LinkProviderUtils.getRedirectUrl("space", space.getId()));
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activity.getId()));
        templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activity.getId()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo message : notifications) {
                String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                Space space = Utils.getSpaceService().getSpaceByPrettyName(activity.getStreamOwner());
                SocialNotificationUtils.processInforSendTo(map, space.getId(), message.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey()));
            }
            writer.append(SocialNotificationUtils.getMessageByIds(map, templateContext));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return spaceIdentity != null && !activity.getPosterId().equals(spaceIdentity.getId());
    }
}

