/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class RelationshipRecievedRequestPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "RelationshipRecievedRequestPlugin";

    public RelationshipRecievedRequestPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Relationship relation = (Relationship)ctx.value(SocialNotificationUtils.RELATIONSHIP);
        return NotificationInfo.instance().key(this.getId()).to(relation.getReceiver().getRemoteId()).with("sender", relation.getSender().getRemoteId()).with(SocialNotificationUtils.RELATIONSHIP_ID.getKey(), relation.getId()).end();
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        String sender = notification.getValueOwnerParameter("sender");
        String toUser = notification.getTo();
        SocialNotificationUtils.addFooterAndFirstName(toUser, templateContext);
        Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", sender, true);
        Profile userProfile = identity.getProfile();
        templateContext.put((Object)"PORTAL_NAME", (Object)System.getProperty("exo.notifications.portalname", "eXo"));
        templateContext.put((Object)"USER", (Object)userProfile.getFullName());
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(userProfile));
        templateContext.put((Object)"ACCEPT_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getConfirmInvitationToConnectUrl(sender, toUser));
        templateContext.put((Object)"REFUSE_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getIgnoreInvitationToConnectUrl(sender, toUser));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo message : notifications) {
                SocialNotificationUtils.processInforSendTo(receiverMap, first.getTo(), message.getValueOwnerParameter(SocialNotificationUtils.SENDER.getKey()));
            }
            writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext, "connections_request"));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }
}

