/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class RequestJoinSpacePlugin
extends AbstractNotificationPlugin {
    public static final String ID = "RequestJoinSpacePlugin";

    public RequestJoinSpacePlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Space space = (Space)ctx.value(SocialNotificationUtils.SPACE);
        String userId = (String)ctx.value(SocialNotificationUtils.REMOTE_ID);
        return NotificationInfo.instance().key(this.getId()).with("request_from", userId).with("spaceId", space.getId()).to(Arrays.asList(space.getManagers()));
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
        Space space = Utils.getSpaceService().getSpaceById(spaceId);
        Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("request_from"), true);
        Profile userProfile = identity.getProfile();
        templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
        templateContext.put((Object)"USER", (Object)userProfile.getFullName());
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        templateContext.put((Object)"SPACE_URL", (Object)LinkProviderUtils.getRedirectUrl("space_members", space.getId()));
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(userProfile));
        templateContext.put((Object)"VALIDATE_SPACE_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getValidateRequestToJoinSpaceUrl(space.getId(), identity.getRemoteId()));
        templateContext.put((Object)"REFUSE_SPACE_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getRefuseRequestToJoinSpaceUrl(space.getId(), identity.getRemoteId()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo message : notifications) {
                String spaceId = message.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
                String fromUser = message.getValueOwnerParameter("request_from");
                SocialNotificationUtils.processInforSendTo(map, spaceId, fromUser);
            }
            writer.append(SocialNotificationUtils.getMessageByIds(map, templateContext));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        Space space = (Space)ctx.value(SocialNotificationUtils.SPACE);
        return space.getRegistration().equals("validation");
    }
}

