/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class QueryResultPageList<E>
extends AbstractPageList<E> {
    private static final Log LOG = ExoLogger.getLogger((String)QueryResultPageList.class.getName());
    private static final String ORDER_BY = "ORDER BY";
    private QueryData queryData_;
    private int bufferSize_;
    private int offset_;
    protected List<E> buffer;
    private Set<E> dataSet;

    public QueryResultPageList(int pageSize, QueryData queryData, int total, int bufferSize, NodeSearchFilter filter, SearchDataCreator creator) {
        super(pageSize);
        this.setTotalNodes(total);
        this.queryData_ = queryData.clone();
        this.offset_ = 0;
        this.bufferSize_ = bufferSize;
        this.filter = filter;
        this.searchDataCreator = creator;
        this.setAvailablePage(total);
        this.removeRedundantPages(Math.min(this.bufferSize_ / pageSize, 5));
        this.dataSet = new HashSet();
    }

    public int getBufferSize() {
        return this.bufferSize_;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize_ = bufferSize;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setOffset(int offset) {
        this.offset_ = offset;
    }

    public QueryData getQueryData() {
        return this.queryData_;
    }

    public void setQueryData(QueryData queryData) {
        this.queryData_ = queryData;
    }

    public void setPageSize(int pageSize) {
        super.setPageSize(pageSize);
        this.offset_ = 0;
    }

    public List getAll() throws Exception {
        return null;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (this.buffer == null || this.buffer.size() == 0) {
            this.queryDataForBuffer();
        }
        int firstBufferPage = this.offset_ / this.getPageSize() + 1;
        int lastBufferPage = (this.offset_ + this.buffer.size() - 1) / this.getPageSize() + 1;
        int bufferPage = this.bufferSize_ / this.getPageSize();
        int offsetPage = firstBufferPage;
        if (page < firstBufferPage || page > lastBufferPage || this.buffer.size() == 0) {
            if (page < firstBufferPage) {
                offsetPage = Math.max(1, page - bufferPage / 3 * 2);
            } else if (page > lastBufferPage) {
                offsetPage = page;
            }
            this.offset_ = (offsetPage - 1) * this.getPageSize();
            this.queryDataForBuffer();
        }
        this.currentListPage_ = new ArrayList();
        for (int i = this.getFrom(); i < this.getTo(); ++i) {
            if (i - this.offset_ >= this.buffer.size()) continue;
            E data = this.buffer.get(i - this.offset_);
            this.currentListPage_.add(data);
        }
    }

    private void queryDataForBuffer() throws Exception {
        this.buffer = new ArrayList();
        this.dataSet = new HashSet();
        SessionProvider sessionProvider = this.queryData_.isSystemSession() ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(this.queryData_.getWorkSpace(), WCMCoreUtils.getRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(this.queryData_.getQueryStatement(), this.queryData_.getLanguage_());
        ((QueryImpl)query).setOffset((long)this.offset_);
        long prevSize = 0L;
        int bufSize = this.bufferSize_;
        int offset = 0;
        int count = 0;
        this.buffer.clear();
        this.dataSet.clear();
        while (true) {
            ((QueryImpl)query).setOffset((long)offset);
            ((QueryImpl)query).setLimit((long)bufSize);
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            RowIterator rowIter = queryResult.getRows();
            long size = iter.getSize();
            while (iter.hasNext() && count < this.bufferSize_) {
                Row newRow;
                Object data;
                Node newNode = iter.nextNode();
                if (this.filter != null) {
                    newNode = this.filter.filterNodeToDisplay(newNode);
                }
                if (newNode == null || this.searchDataCreator == null || (data = this.searchDataCreator.createData(newNode, newRow = rowIter.nextRow())) == null || this.dataSet.contains(data)) continue;
                this.buffer.add(data);
                this.dataSet.add(data);
                ++count;
            }
            if (count == this.bufferSize_ || size == prevSize) break;
            offset = bufSize;
            bufSize = 2 * bufSize;
            prevSize = size;
        }
    }

    @Override
    public void sortData() {
        block4: {
            if (this.sortByField != null) {
                String statement = this.queryData_.getQueryStatement().toUpperCase();
                int orderByIndex = statement.lastIndexOf(ORDER_BY);
                String[] orderStrings = orderByIndex >= 0 ? this.queryData_.getQueryStatement().substring(orderByIndex + ORDER_BY.length()).split(",") : new String[]{};
                StringBuffer newStatement = orderByIndex >= 0 ? new StringBuffer(this.queryData_.getQueryStatement().substring(0, orderByIndex + ORDER_BY.length())) : new StringBuffer(this.queryData_.getQueryStatement());
                newStatement.append(" ").append(this.getSortByField(this.sortByField, this.queryData_.getLanguage_())).append(" ").append(this.getOrderForQuery(this.order, this.queryData_.getLanguage_()));
                for (String orderString : orderStrings) {
                    if (orderString.toUpperCase().contains(this.sortByField.toUpperCase())) continue;
                    newStatement.append(", ").append(orderString);
                }
                this.queryData_.setQueryStatement(newStatement.toString());
                try {
                    this.buffer.clear();
                    this.populateCurrentPage(this.currentPage_);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
    }

    private String getSortByField(String sortField, String queryLanguage) {
        return ("sql".equals(queryLanguage) ? sortField : "@" + sortField) + ("jcr:score".equals(sortField.toLowerCase()) ? "()" : "");
    }

    private String getOrderForQuery(String order, String queryLanguage) {
        if ("sql".equals(queryLanguage)) {
            return order.toUpperCase().startsWith("A") ? "ASC" : "DESC";
        }
        return order.toUpperCase().startsWith("A") ? "ascending" : "descending";
    }
}

