/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.XPathUtils;

public class EventQuery {
    private String nodeType = "exo:calendarEvent";
    private String eventType;
    private String text = null;
    private String[] categoryIds = null;
    private String[] calendarIds = null;
    private String[] filterCalendarIds = null;
    private Calendar fromDate = null;
    private Calendar toDate = null;
    private String calendarPath;
    private String priority;
    private String state;
    private String[] orderBy;
    private String[] participants;
    private Boolean excludeRepeatEvent = false;
    private String orderType = "ascending";
    private String queryType = "xpath";
    private long limitedItems = 0L;

    public EventQuery() {
    }

    public EventQuery(EventQuery eventQuery) {
        this.setCalendarId(eventQuery.getCalendarId());
        this.setCalendarPath(eventQuery.getCalendarPath());
        this.setCategoryId(eventQuery.getCategoryId());
        this.setEventType(eventQuery.getEventType());
        this.setExcludeRepeatEvent(eventQuery.getExcludeRepeatEvent());
        this.setFilterCalendarIds(eventQuery.getFilterCalendarIds());
        this.setFromDate(eventQuery.getFromDate());
        this.setLimitedItems(eventQuery.getLimitedItems());
        this.setNodeType(eventQuery.getNodeType());
        this.setOrderBy(eventQuery.getOrderBy());
        this.setOrderType(eventQuery.getOrderType());
        this.setParticipants(eventQuery.getParticipants());
        this.setPriority(eventQuery.getPriority());
        this.setQueryType(eventQuery.getQueryType());
        this.setState(eventQuery.getState());
        this.setText(eventQuery.getText());
        this.setToDate(eventQuery.getToDate());
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nt) {
        this.nodeType = nt;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setText(String fullTextSearch) {
        this.text = fullTextSearch;
    }

    public String getText() {
        return this.text;
    }

    public String[] getCategoryId() {
        return this.categoryIds;
    }

    public void setCategoryId(String[] categoryIds) {
        this.categoryIds = categoryIds;
    }

    public String[] getCalendarId() {
        return this.calendarIds;
    }

    public void setCalendarId(String[] calendarIds) {
        this.calendarIds = calendarIds;
    }

    public void setFilterCalendarIds(String[] filterCalendarIds) {
        this.filterCalendarIds = filterCalendarIds;
    }

    public String[] getFilterCalendarIds() {
        return this.filterCalendarIds;
    }

    public Calendar getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Calendar fromDate) {
        this.fromDate = fromDate;
    }

    public Calendar getToDate() {
        return this.toDate;
    }

    public void setToDate(Calendar toDate) {
        this.toDate = toDate;
    }

    public String getCalendarPath() {
        return this.calendarPath;
    }

    public void setCalendarPath(String calendarPath) {
        this.calendarPath = calendarPath;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String st) {
        this.state = st;
    }

    public String[] getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String[] order) {
        this.orderBy = order;
    }

    public String[] getParticipants() {
        return this.participants;
    }

    public void setParticipants(String[] par) {
        this.participants = par;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String type) {
        this.orderType = type;
    }

    public String getQueryStatement() throws Exception {
        StringBuilder queryString = null;
        if (this.queryType.equals("sql")) {
            queryString = !Utils.isEmpty(this.calendarPath) ? new StringBuilder(" select * from ").append(this.nodeType).append(" where jcr:path like '").append(this.calendarPath).append("/%'") : new StringBuilder(" select * from ").append(this.nodeType).append(" ");
            if (!Utils.isEmpty(this.text)) {
                String val = this.escapeLikeQuery(this.text);
                queryString.append(" and (").append("exo:summary").append(" like '%").append(val).append("%'");
                queryString.append(" ESCAPE '\\'");
                queryString.append(" or ").append("exo:description").append(" like '%").append(val).append("%'");
                queryString.append(" ESCAPE '\\'");
                queryString.append(" or ").append("exo:location").append(" like '%").append(val).append("%'");
                queryString.append(" ESCAPE '\\'");
                queryString.append(" or ").append("exo:participant").append(" like '%").append(val).append("%'");
                queryString.append(" ESCAPE '\\'");
                queryString.append(" or ").append("exo:invitation").append(" like '%").append(val).append("%'");
                queryString.append(" ESCAPE '\\'");
                queryString.append(")");
            }
            if (!Utils.isEmpty(this.eventType)) {
                queryString.append(" and ").append("exo:eventType").append(" = '").append(this.eventType).append("'");
            }
            if (!Utils.isEmpty(this.priority)) {
                queryString.append(" and ").append("exo:priority").append(" = '").append(this.priority).append("'");
            }
            if (!Utils.isEmpty(this.state)) {
                queryString.append(" and ").append("exo:eventState").append(" = '").append(this.state).append("'");
            }
            if (this.categoryIds != null && this.categoryIds.length > 0) {
                for (String category : this.categoryIds) {
                    queryString.append(" and ").append("exo:eventCategoryId").append(" = '").append(category).append("'");
                }
            }
            if (this.calendarIds != null && this.calendarIds.length > 0) {
                for (String calendarId : this.calendarIds) {
                    queryString.append(" and ").append("exo:calendarId").append(" = '").append(calendarId).append("'");
                }
            }
            return queryString.toString();
        }
        queryString = this.calendarPath != null ? new StringBuilder("/jcr:root").append(XPathUtils.escapeIllegalXPathName((String)this.calendarPath)).append("//element(*,").append(this.nodeType).append(")") : new StringBuilder("/jcr:root//element(*,").append(this.nodeType).append(")");
        boolean hasConjuntion = false;
        StringBuilder stringBuffer = new StringBuilder("[");
        if (this.text != null && this.text.length() > 0) {
            String val = this.escapeContainsQuery(this.text);
            stringBuffer.append("(jcr:contains(@").append("exo:summary").append(", '").append(val).append("')").append(" or jcr:contains(@").append("exo:description").append(", '").append(val).append("')").append(" or jcr:contains(@").append("exo:location").append(", '").append(val).append("')").append(" or jcr:contains(@").append("exo:participant").append(", '").append(val).append("')").append(" or jcr:contains(@").append("exo:invitation").append(", '").append(val).append("'))");
            hasConjuntion = true;
        }
        if (this.eventType != null && this.eventType.length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:eventType='").append(this.eventType).append("'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.priority != null && this.priority.length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:priority='").append(this.priority).append("'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.state != null && this.state.length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:eventState='").append(this.state).append("'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.categoryIds != null && this.categoryIds.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (int i = 0; i < this.categoryIds.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:eventCategoryId='").append(this.categoryIds[i]).append("'");
                    continue;
                }
                stringBuffer.append(" or @exo:eventCategoryId='").append(this.categoryIds[i]).append("'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.calendarIds != null && this.calendarIds.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (int i = 0; i < this.calendarIds.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:calendarId='").append(this.calendarIds[i]).append("'");
                    continue;
                }
                stringBuffer.append(" or @exo:calendarId='").append(this.calendarIds[i]).append("'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.filterCalendarIds != null && this.filterCalendarIds.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (int i = 0; i < this.filterCalendarIds.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:calendarId !='").append(this.filterCalendarIds[i]).append("'");
                    continue;
                }
                stringBuffer.append(" and @exo:calendarId !='").append(this.filterCalendarIds[i]).append("'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.participants != null && this.participants.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (int i = 0; i < this.participants.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:participant='").append(this.participants[i]).append("'");
                    continue;
                }
                stringBuffer.append(" or @exo:participant='").append(this.participants[i]).append("'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.fromDate != null && this.toDate != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("(");
            stringBuffer.append("@exo:fromDateTime <= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("') and ");
            stringBuffer.append("@exo:toDateTime >= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("')");
            stringBuffer.append(") or (");
            stringBuffer.append("@exo:fromDateTime >= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("') and ");
            stringBuffer.append("@exo:fromDateTime <= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("')");
            stringBuffer.append(") or (");
            stringBuffer.append("@exo:toDateTime >= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("') and ");
            stringBuffer.append("@exo:toDateTime <= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("')");
            stringBuffer.append(") or (");
            stringBuffer.append("(not(@exo:repeatUntil) or @exo:repeatUntil >=  xs:dateTime('" + ISO8601.format((Calendar)this.fromDate) + "'))");
            stringBuffer.append(" and (not(@exo:repeatFinishDate) or @exo:repeatFinishDate >=  xs:dateTime('" + ISO8601.format((Calendar)this.fromDate) + "'))");
            stringBuffer.append(" and @exo:repeat != 'norepeat'");
            stringBuffer.append(")");
            stringBuffer.append(")");
            hasConjuntion = true;
        } else if (this.fromDate != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:fromDateTime >= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("')");
            stringBuffer.append(")");
            hasConjuntion = true;
        } else if (this.toDate != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:toDateTime <= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.excludeRepeatEvent != null && this.excludeRepeatEvent.booleanValue()) {
            stringBuffer.append("and not(@jcr:mixinTypes='exo:repeatCalendarEvent' and @exo:repeat!='").append(CalendarEvent.RP_NOREPEAT).append("' and @exo:recurrenceId='')");
        }
        stringBuffer.append("]");
        if (this.orderBy != null && this.orderBy.length > 0 && this.orderType != null && this.orderType.length() > 0) {
            for (int i = 0; i < this.orderBy.length; ++i) {
                if (i == 0) {
                    stringBuffer.append(" order by @").append(this.orderBy[i].trim()).append(" ").append(this.orderType);
                    continue;
                }
                stringBuffer.append(", order by @").append(this.orderBy[i].trim()).append(" ").append(this.orderType);
            }
            hasConjuntion = true;
        }
        if (hasConjuntion) {
            queryString.append(stringBuffer.toString());
        }
        return queryString.toString();
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setLimitedItems(int limitedItems) {
        this.limitedItems = limitedItems;
    }

    public void setLimitedItems(long limitedItems) {
        this.limitedItems = limitedItems;
    }

    public long getLimitedItems() {
        return this.limitedItems;
    }

    public void setExcludeRepeatEvent(Boolean excludeRepeatEvent) {
        this.excludeRepeatEvent = excludeRepeatEvent;
    }

    public Boolean getExcludeRepeatEvent() {
        return this.excludeRepeatEvent;
    }

    protected String escapeContainsQuery(String s) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '~') {
                if (i < s.length() - 1 && s.charAt(i + 1) == '~') continue;
                String subString = s.substring(i + 1);
                try {
                    float f = Float.parseFloat(subString);
                    if (f >= 0.0f && f <= 1.0f) {
                        buffer.append(ch);
                        continue;
                    }
                    buffer.append('\\').append(ch);
                }
                catch (Exception ex) {
                    buffer.append('\\').append(ch);
                }
                continue;
            }
            if (ch == '\"' || ch == '-' || ch == '\\' || ch == '{' || ch == '}' || ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == ':' || ch == '^' || ch == '!') {
                buffer.append('\\').append(ch);
                continue;
            }
            if (ch == '\'') {
                buffer.append("''");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    protected String escapeLikeQuery(String s) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%' || ch == '_' || ch == '\\') {
                buffer.append('\\').append(ch);
                continue;
            }
            if (ch == '\'') {
                buffer.append("''");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

