/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPageInfo;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRelatedPages;
import org.exoplatform.wiki.webui.control.UIRelatedPagesContainer;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.listener.UIRelatedPagesContainerActionListener;

@ComponentConfig(events={@EventConfig(listeners={RemoveRelatedPageActionListener.class}, confirm="UIWikiPageInfo.msg.confirm-remove-rpage")})
public class RemoveRelatedPageActionComponent
extends UIComponent {
    private static final Log log = ExoLogger.getLogger(UIRelatedPagesContainer.class);
    public static final String WIKI_TYPE = "wikitype";
    public static final String PAGE_OWNER = "owner";
    public static final String PAGE_ID = "pageid";
    public static final String ACTION = "RemoveRelatedPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new EditPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    String getRemovePageActionLink(WikiPageParams wikiParams) {
        Parameter[] params = new Parameter[]{new Parameter(WIKI_TYPE, wikiParams.getType()), new Parameter(PAGE_OWNER, wikiParams.getOwner()), new Parameter(PAGE_ID, wikiParams.getPageId())};
        try {
            return this.event(ACTION, null, params);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"getting Remove related page failed", (Throwable)e);
            }
            return "";
        }
    }

    public static class RemoveRelatedPageActionListener
    extends UIRelatedPagesContainerActionListener<RemoveRelatedPageActionComponent> {
        @Override
        protected void processEvent(Event<RemoveRelatedPageActionComponent> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            UIWikiPageInfo uicomponent = (UIWikiPageInfo)((RemoveRelatedPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPageInfo.class);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)uicomponent.getAncestorOfType(UIWikiPortlet.class);
            UIWikiRelatedPages relatedCtn = (UIWikiRelatedPages)wikiPortlet.findFirstComponentOfType(UIWikiRelatedPages.class);
            String wikiType = requestContext.getRequestParameter(RemoveRelatedPageActionComponent.WIKI_TYPE);
            String owner = requestContext.getRequestParameter(RemoveRelatedPageActionComponent.PAGE_OWNER);
            String pageId = requestContext.getRequestParameter(RemoveRelatedPageActionComponent.PAGE_ID);
            try {
                WikiPageParams relatedPageParams = new WikiPageParams(wikiType, owner, pageId);
                WikiService service = (WikiService)uicomponent.getApplicationComponent(WikiService.class);
                service.removeRelatedPage(Utils.getCurrentWikiPageParams(), relatedPageParams);
                if (relatedCtn != null) {
                    requestContext.addUIComponentToUpdateByAjax((UIComponent)relatedCtn);
                }
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("can not remove related page [%s]", pageId), (Throwable)e);
                }
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("can not remove this page", null, 1));
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uicomponent);
        }
    }
}

