/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.hierarchical;

import java.util.AbstractList;
import java.util.Iterator;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ThrowableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnyChildList<E>
extends AbstractList<E> {
    private final EntityContext parentCtx;
    private final String prefix;
    private final Class<E> relatedClass;

    public AnyChildList(EntityContext parentCtx, String prefix, Class<E> relatedClass) {
        this.relatedClass = relatedClass;
        this.prefix = prefix;
        this.parentCtx = parentCtx;
    }

    @Override
    public void add(int index, E addedElement) {
        Object nextElement;
        block7: {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (addedElement == null) {
                throw new NullPointerException("No null element can be inserted");
            }
            if (!this.relatedClass.isInstance(addedElement)) {
                throw new ClassCastException("Cannot cast object with class " + addedElement.getClass().getName() + " as child expected class " + this.relatedClass.getName());
            }
            Iterator<E> iterator = this.iterator();
            while (true) {
                if (index == 0) {
                    nextElement = iterator.hasNext() ? iterator.next() : null;
                    break block7;
                }
                if (!iterator.hasNext()) break;
                iterator.next();
                --index;
            }
            throw new IndexOutOfBoundsException();
        }
        DomainSession session = this.parentCtx.getSession();
        EntityContext addedCtx = session.unwrapEntity(addedElement);
        this.parentCtx.addChild(ThrowableFactory.ISE, ThrowableFactory.IAE, this.prefix, addedCtx);
        if (nextElement == null) {
            this.parentCtx.orderBefore(addedCtx, null);
        } else {
            EntityContext nextCtx = session.unwrapEntity(nextElement);
            this.parentCtx.orderBefore(addedCtx, nextCtx);
        }
    }

    @Override
    public boolean add(E addedElement) {
        if (addedElement == null) {
            throw new NullPointerException("No null element can be inserted");
        }
        if (!this.relatedClass.isInstance(addedElement)) {
            throw new ClassCastException("Cannot cast object with class " + addedElement.getClass().getName() + " as child expected class " + this.relatedClass.getName());
        }
        DomainSession session = this.parentCtx.getSession();
        EntityContext addedCtx = session.unwrapEntity(addedElement);
        this.parentCtx.addChild(ThrowableFactory.ISE, ThrowableFactory.IAE, this.prefix, addedCtx);
        return true;
    }

    @Override
    public E set(int index, E addedElement) {
        if (addedElement == null) {
            throw new NullPointerException("No null element can be inserted");
        }
        if (!this.relatedClass.isInstance(addedElement)) {
            throw new ClassCastException("Cannot cast object with class " + addedElement.getClass().getName() + " as child expected class " + this.relatedClass.getName());
        }
        E removedElement = this.get(index);
        DomainSession session = this.parentCtx.getSession();
        EntityContext removedCtx = session.unwrapEntity(removedElement);
        EntityContext addedCtx = session.unwrapEntity(addedElement);
        this.parentCtx.addChild(ThrowableFactory.ASSERT, ThrowableFactory.IAE, this.prefix, addedCtx);
        this.parentCtx.orderBefore(addedCtx, removedCtx);
        session.remove(removedCtx);
        return removedElement;
    }

    @Override
    public E remove(int index) {
        E removedElement = this.get(index);
        DomainSession session = this.parentCtx.getSession();
        EntityContext removedCtx = session.unwrapEntity(removedElement);
        session.remove(removedCtx);
        return removedElement;
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (E o : this) {
            if (index == 0) {
                return o;
            }
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.parentCtx.getChildren(this.relatedClass);
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }
}

