/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.context;

import java.lang.reflect.Type;
import javax.inject.Inject;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.rendering.impl.RenderingServiceImpl;
import org.exoplatform.wiki.rendering.reference.ObjectReferenceConverter;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiContext;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceType;

public class DefaultMarkupContextManager
implements MarkupContextManager {
    private static final Log LOG = ExoLogger.getLogger(DefaultMarkupContextManager.class);
    @Inject
    private ComponentManager componentManager;
    private static final String DEFAULT_WIKI = "xwiki";
    private static final String DEFAULT_SPACE = "Main";
    private static final String DEFAULT_PAGE = "WebHome";
    private static final String PORTAL = "portal";
    private static final String CLASSIC = "classic";
    private static final String WIKIHOME = "Wiki_Home";

    @Override
    public WikiContext getMarkupContext(String objectName, ResourceType type) {
        WikiContext wikiMarkupContext;
        block17: {
            wikiMarkupContext = new WikiContext();
            try {
                WikiContext wikiContext;
                ObjectReferenceResolver stringObjectReferenceResolver;
                AttachmentReferenceResolver stringAttachmentReferenceResolver;
                DocumentReferenceResolver stringDocumentReferenceResolver;
                block16: {
                    stringDocumentReferenceResolver = (DocumentReferenceResolver)this.componentManager.getInstance((Type)DocumentReferenceResolver.TYPE_STRING);
                    stringAttachmentReferenceResolver = (AttachmentReferenceResolver)this.componentManager.getInstance((Type)AttachmentReferenceResolver.TYPE_STRING);
                    stringObjectReferenceResolver = (ObjectReferenceResolver)this.componentManager.getInstance((Type)ObjectReferenceResolver.TYPE_STRING);
                    RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
                    Execution execution = ((RenderingServiceImpl)renderingService).getExecution();
                    ExecutionContext ec = execution.getContext();
                    wikiContext = null;
                    if (ec != null) {
                        wikiContext = (WikiContext)ec.getProperty("wikicontext");
                        try {
                            ObjectReferenceConverter converter = (ObjectReferenceConverter)this.componentManager.getInstance(ObjectReferenceConverter.class, wikiContext.getSyntax());
                            objectName = converter.convert(objectName);
                        }
                        catch (ComponentLookupException e) {
                            if (!LOG.isDebugEnabled()) break block16;
                            LOG.debug((Object)String.format("Syntax %s doesn't have any object reference converter", wikiContext.getSyntax()));
                        }
                    }
                }
                boolean isConfluenceSyntax = objectName.indexOf(94) > 0;
                DocumentReference entityReference = null;
                if (ResourceType.DOCUMENT.equals((Object)type)) {
                    entityReference = stringDocumentReferenceResolver.resolve((Object)objectName, new Object[0]);
                } else if (ResourceType.ATTACHMENT.equals((Object)type) || ResourceType.ICON.equals((Object)type)) {
                    Object object = entityReference = isConfluenceSyntax ? stringObjectReferenceResolver.resolve((Object)objectName) : stringAttachmentReferenceResolver.resolve((Object)objectName, new Object[0]);
                }
                if (entityReference != null) {
                    EntityReference attachmentReference;
                    wikiMarkupContext.setType(entityReference.extractReference(EntityType.WIKI).getName());
                    wikiMarkupContext.setOwner(entityReference.extractReference(EntityType.SPACE).getName());
                    wikiMarkupContext.setPageTitle(entityReference.extractReference(EntityType.DOCUMENT).getName());
                    wikiMarkupContext.setPageId(wikiMarkupContext.getPageTitle());
                    wikiMarkupContext.setPageId(TitleResolver.getId(wikiMarkupContext.getPageId(), false));
                    EntityReference entityReference2 = attachmentReference = isConfluenceSyntax ? entityReference.extractReference(EntityType.OBJECT) : entityReference.extractReference(EntityType.ATTACHMENT);
                    if (attachmentReference != null) {
                        wikiMarkupContext.setAttachmentName(attachmentReference.getName());
                    }
                    if (ResourceType.ICON.equals((Object)type)) {
                        wikiMarkupContext.setAttachmentName(wikiMarkupContext.getAttachmentName() + ".gif");
                    }
                    if (wikiContext != null) {
                        wikiMarkupContext.setPortalURL(wikiContext.getPortalURL());
                        wikiMarkupContext.setPortletURI(wikiContext.getPortletURI());
                    } else {
                        wikiContext = new WikiContext();
                        wikiContext.setType(PORTAL);
                        wikiContext.setOwner(CLASSIC);
                        wikiContext.setPageId(WIKIHOME);
                    }
                    if (DEFAULT_WIKI.equals(wikiMarkupContext.getType())) {
                        wikiMarkupContext.setType(wikiContext.getType());
                    }
                    if (DEFAULT_SPACE.equals(wikiMarkupContext.getOwner())) {
                        wikiMarkupContext.setOwner(wikiContext.getOwner());
                    }
                    if (DEFAULT_PAGE.equals(wikiMarkupContext.getPageId())) {
                        wikiMarkupContext.setPageId(wikiContext.getPageId());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block17;
                LOG.debug((Object)("Couldn't get wiki context for markup: " + objectName), (Throwable)e);
            }
        }
        return wikiMarkupContext;
    }
}

