/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.Node;
import java.util.List;

class AstChangeProxy {
    private final List<ChangeListener> listeners = Lists.newArrayList();

    AstChangeProxy() {
    }

    final void registerListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    final void unregisterListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyOfRemoval(Node node) {
        for (ChangeListener listener : this.listeners) {
            listener.nodeRemoved(node);
        }
    }

    final void removeChild(Node parent, Node node) {
        parent.removeChild(node);
        this.notifyOfRemoval(node);
    }

    final void replaceWith(Node parent, Node node, Node replacement) {
        this.replaceWith(parent, node, Lists.newArrayList((Object[])new Node[]{replacement}));
    }

    final void replaceWith(Node parent, Node node, List<Node> replacements) {
        Preconditions.checkNotNull(replacements, (Object)"\"replacements\" is null.");
        int size = replacements.size();
        if (size == 1 && node.isEquivalentTo(replacements.get(0))) {
            return;
        }
        int parentType = parent.getType();
        Preconditions.checkState((size == 1 || parentType == 125 || parentType == 132 || parentType == 126 ? 1 : 0) != 0);
        if (parentType == 126 && size != 1) {
            Node block = new Node(125);
            for (Node newChild : replacements) {
                newChild.copyInformationFrom(node);
                Node oldParent = newChild.getParent();
                block.addChildToBack(newChild);
            }
            parent.replaceChild(node, block);
        } else {
            for (Node newChild : replacements) {
                newChild.copyInformationFrom(node);
                Node oldParent = newChild.getParent();
                parent.addChildBefore(newChild, node);
            }
            parent.removeChild(node);
        }
        this.notifyOfRemoval(node);
    }

    static interface ChangeListener {
        public void nodeRemoved(Node var1);
    }
}

