/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;

class RescopeGlobalSymbols
implements CompilerPass {
    private static final String DISAMBIGUATION_SUFFIX = "$";
    private final AbstractCompiler compiler;
    private final String globalSymbolNamespace;
    private final boolean addExtern;

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace, boolean addExtern) {
        this.compiler = compiler;
        this.globalSymbolNamespace = globalSymbolNamespace;
        this.addExtern = addExtern;
    }

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace) {
        this(compiler, globalSymbolNamespace, true);
    }

    private void addExternForGlobalSymbolNamespace() {
        Node nameNode = Node.newString(38, this.globalSymbolNamespace);
        Node varNode = new Node(118);
        varNode.addChildToBack(nameNode);
        CompilerInput input = this.compiler.newExternInput("{RescopeGlobalSymbolsNamespaceVar}");
        input.getAstRoot(this.compiler).addChildrenToBack(varNode);
        this.compiler.reportCodeChange();
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.addExtern) {
            this.addExternForGlobalSymbolNamespace();
        }
        NodeTraversal.traverse(this.compiler, root, new RewriteGlobalFunctionStatementsToVarAssignmentsCallback());
        NodeTraversal.traverse(this.compiler, root, new RewriteScopeCallback());
        NodeTraversal.traverse(this.compiler, root, new RemoveGlobalVarCallback());
    }

    private class RemoveGlobalVarCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RemoveGlobalVarCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() != 118) {
                return;
            }
            ArrayList<Node> commas = new ArrayList<Node>();
            ArrayList<Node> interestingChildren = new ArrayList<Node>();
            for (Node c : n.children()) {
                if (!c.isAssign() && !parent.isFor()) continue;
                interestingChildren.add(c);
            }
            for (Node c : interestingChildren) {
                if (parent.isFor() && parent.getFirstChild() == n) {
                    commas.add(c.cloneTree());
                    continue;
                }
                Node expr = new Node(130);
                expr.copyInformationFrom(c);
                expr.addChildToBack(c.cloneTree());
                parent.addChildBefore(expr, n);
            }
            if (commas.size() > 0) {
                Node comma = this.joinOnComma(commas, n);
                parent.addChildBefore(comma, n);
            }
            parent.removeChild(n);
            RescopeGlobalSymbols.this.compiler.reportCodeChange();
        }

        private Node joinOnComma(List<Node> commas, Node source) {
            Node comma = commas.get(0);
            for (int i = 1; i < commas.size(); ++i) {
                Node nextComma = new Node(85, comma, commas.get(i));
                nextComma.copyInformationFrom(source);
                comma = nextComma;
            }
            return comma;
        }
    }

    private class RewriteScopeCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private RewriteScopeCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() != 38) {
                return;
            }
            String name = n.getString();
            if (parent.isFunction() && name.length() == 0) {
                return;
            }
            Scope.Var var = t.getScope().getVar(name);
            if (var == null) {
                return;
            }
            if (var.isExtern()) {
                return;
            }
            if (!var.isExtern() && (name.equals(RescopeGlobalSymbols.this.globalSymbolNamespace) || name.indexOf(RescopeGlobalSymbols.this.globalSymbolNamespace + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX) == 0)) {
                n.setString(name + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX);
                RescopeGlobalSymbols.this.compiler.reportCodeChange();
            }
            if (!var.isGlobal()) {
                return;
            }
            Node nameNode = var.getNameNode();
            if (nameNode != null && nameNode.getParent() != null && nameNode.getParent().isCatch()) {
                return;
            }
            this.replaceSymbol(n, name);
        }

        private void replaceSymbol(Node node, String name) {
            Node parent = node.getParent();
            Node replacement = new Node(33, Node.newString(38, RescopeGlobalSymbols.this.globalSymbolNamespace).copyInformationFrom(node), Node.newString(name).copyInformationFrom(node));
            replacement.copyInformationFrom(node);
            if (node.hasChildren()) {
                Node assign = new Node(86, replacement, node.removeFirstChild());
                parent.replaceChild(node, assign);
            } else {
                parent.replaceChild(node, replacement);
            }
            RescopeGlobalSymbols.this.compiler.reportCodeChange();
        }
    }

    private class RewriteGlobalFunctionStatementsToVarAssignmentsCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RewriteGlobalFunctionStatementsToVarAssignmentsCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                String name = NodeUtil.getFunctionName(n);
                n.getFirstChild().setString("");
                Node prev = parent.getChildBefore(n);
                n.detachFromParent();
                Node var = NodeUtil.newVarNode(name, n);
                if (prev == null) {
                    parent.addChildToFront(var);
                } else {
                    parent.addChildAfter(var, prev);
                }
                RescopeGlobalSymbols.this.compiler.reportCodeChange();
            }
        }
    }
}

