/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.ExoScriptingConsole;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.platform.gadget.services.ExoScriptingConsole.ConsoleTask;
import org.exoplatform.platform.gadget.services.ExoScriptingConsole.ExoScriptingConsole;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/console-manager")
public class ExoScriptingConsoleRestService
implements ResourceContainer {
    private static String DELIMITER = "~";
    public static Map<String, ExoScriptingConsole> _consoles = new HashMap<String, ExoScriptingConsole>();
    public static Map<String, ConsoleTask> _consoleTasks = new HashMap<String, ConsoleTask>();
    private static Timer _timer = new Timer();
    private static final CacheControl cacheControl;

    private static ExoScriptingConsole getConsole(String consoleId) throws Exception {
        if (_consoles.containsKey(consoleId)) {
            return _consoles.get(consoleId);
        }
        ExoScriptingConsole newConsole = new ExoScriptingConsole(consoleId.split(DELIMITER)[2]);
        _consoles.put(consoleId, newConsole);
        ConsoleTask newConsoleTask = new ConsoleTask(consoleId, ConsoleTask.TIME_TO_LIVE);
        _consoleTasks.put(consoleId, newConsoleTask);
        _timer.schedule((TimerTask)newConsoleTask, ConsoleTask.PERIOD, (long)ConsoleTask.PERIOD);
        return newConsole;
    }

    public static String runInConsole(String consoleId, String script) throws Exception {
        Collection roles = ConversationState.getCurrent().getIdentity().getRoles();
        if (roles.isEmpty()) {
            throw new Exception("Session expired. Please login again.");
        }
        if (!roles.contains("administrators") && !roles.contains("developers")) {
            throw new Exception("Permission denied: only administrators or developers are allowed to run console commands");
        }
        ExoScriptingConsole console = ExoScriptingConsoleRestService.getConsole(consoleId);
        _consoleTasks.get(consoleId).increaseTimeToLive(1);
        if (script.equals("history")) {
            String history = console.getHistory();
            if (history.isEmpty()) {
                history = "<empty>";
            }
            return history;
        }
        if (script.equals("dump")) {
            Bindings bindings = console.getVariables();
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : bindings.entrySet()) {
                builder.append((String)entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
            String variables = builder.toString();
            if (variables.isEmpty()) {
                variables = "<empty>";
            }
            return console.toString() + "\nVariables:\n" + variables;
        }
        if (script.equals("refresh")) {
            console.getVariables().clear();
            return "Session refreshed";
        }
        if (script.equals("quit")) {
            _consoles.remove(consoleId);
            return "Session terminated";
        }
        return console.run(script);
    }

    @GET
    @Path(value="run/{sessionId}/{script}")
    @Produces(value={"application/json"})
    public Response run(@PathParam(value="sessionId") String sessionId, @PathParam(value="script") String script) {
        String outputType;
        String output;
        try {
            script = script.replaceAll("%2B", "+").replaceAll("%2F", "/").replaceAll("%5C", "\\\\");
            output = ExoScriptingConsoleRestService.runInConsole(ConversationState.getCurrent().getIdentity().getUserId() + DELIMITER + sessionId, script);
            outputType = "result";
        }
        catch (Exception e) {
            output = e.getMessage();
            outputType = "error";
        }
        return Response.ok((Object)("{\"outputType\":\"" + outputType + "\", \"output\":\"" + output.replaceAll("\\r|\\n", "\\\\n") + "\"}"), (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="history/{sessionId}")
    @Produces(value={"application/json"})
    public Response history(@PathParam(value="sessionId") String sessionId) {
        try {
            ExoScriptingConsole console = ExoScriptingConsoleRestService.getConsole(ConversationState.getCurrent().getIdentity().getUserId() + DELIMITER + sessionId);
            return Response.ok((Object)console.getHistory(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.ok((Object)("Error getting session history: " + e.getMessage()), (String)"application/json").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="languages")
    @Produces(value={"application/json"})
    public Response languages() {
        ArrayList<String> languages = new ArrayList<String>();
        ScriptEngineManager manager = new ScriptEngineManager();
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            languages.add(factory.getLanguageName());
        }
        return Response.ok(languages, (String)"application/json").cacheControl(cacheControl).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

