/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Payload;
import org.exoplatform.services.jcr.impl.core.query.lucene.PropertyMetaData;

public final class SingletonTokenStream
extends TokenStream
implements Externalizable {
    private String value;
    private Payload payload;
    private TermAttribute termAttribute;
    private PayloadAttribute payloadAttribute;
    private boolean consumed = false;

    public SingletonTokenStream() {
        this.termAttribute = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.payloadAttribute = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    }

    public SingletonTokenStream(String value, Payload payload) {
        this.value = value;
        this.payload = payload;
        this.termAttribute = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.payloadAttribute = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    }

    public SingletonTokenStream(String value, int type) {
        this(value, new Payload(new PropertyMetaData(type).toByteArray()));
    }

    public boolean incrementToken() throws IOException {
        if (this.consumed) {
            return false;
        }
        this.clearAttributes();
        this.termAttribute.setTermBuffer(this.value);
        this.payloadAttribute.setPayload(this.payload);
        this.consumed = true;
        return true;
    }

    public void reset() throws IOException {
        this.consumed = false;
    }

    public void close() throws IOException {
        this.consumed = true;
        this.payloadAttribute = null;
        this.termAttribute = null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.payload = (Payload)in.readObject();
        int length = in.readInt();
        byte[] binValue = new byte[length];
        in.read(binValue);
        this.value = new String(binValue, "UTF-8");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.payload);
        byte[] binValue = this.value.getBytes("UTF-8");
        out.writeInt(binValue.length);
        out.write(binValue);
    }
}

