/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.ext.action;

import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.command.action.ActionCatalog;
import org.exoplatform.services.command.action.Condition;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.ext.action.AdvancedAction;
import org.exoplatform.services.jcr.impl.ext.action.AdvancedActionException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SessionActionInterceptor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionActionInterceptor");
    private final ActionCatalog catalog;
    private final ExoContainer container;
    private final String workspaceName;
    private ItemImpl activeItem = null;

    public SessionActionInterceptor(ActionCatalog catalog, ExoContainer container, String workspaceName) {
        this.catalog = catalog;
        this.container = container;
        this.workspaceName = workspaceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddMixin(NodeImpl node, InternalQName mixinType) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)256);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)new InternalQName[]{mixinType});
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EVENT, 256);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var6_5 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddNode(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)1);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)node.getData()));
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            ctx.put(InvocationContext.EVENT, 1);
            this.launch(conditions, ctx);
            Object var5_4 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCheckin(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)8192);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)node.getData()));
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EVENT, 8192);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var5_4 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCheckout(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)16384);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)node.getData()));
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EVENT, 16384);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var5_4 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postLock(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)0x400000);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)node.getData()));
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EVENT, 0x400000);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var5_4 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRead(ItemImpl item) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = item;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)0x1000000);
            conditions.put((Object)"paths", (Object)item.getInternalPath());
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            if (item.isNode()) {
                conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)item.getData()));
            } else {
                conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames(item.parentData()));
            }
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, item);
            ctx.put(InvocationContext.EVENT, 0x1000000);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var5_4 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetProperty(PropertyImpl previousProperty, PropertyImpl currentProperty, NodeData parent, int state) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = currentProperty;
        try {
            int event = -1;
            switch (state) {
                case 1: {
                    event = 4;
                    break;
                }
                case 2: {
                    event = 16;
                    break;
                }
                case 4: {
                    event = 8;
                    break;
                }
                default: {
                    Object var9_6 = null;
                    this.activeItem = null;
                    return;
                }
            }
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)event);
            conditions.put((Object)"paths", (Object)currentProperty.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames(parent));
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, currentProperty);
            ctx.put(InvocationContext.PREVIOUS_ITEM, previousProperty);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            ctx.put(InvocationContext.EVENT, event);
            this.launch(conditions, ctx);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.activeItem = null;
            throw throwable;
        }
        Object var9_7 = null;
        this.activeItem = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUnlock(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)0x800000);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)node.getData()));
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EVENT, 0x800000);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var5_4 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRemoveItem(ItemImpl item) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = item;
        try {
            Condition conditions = new Condition();
            int event = item.isNode() ? 2 : 8;
            conditions.put((Object)"types", (Object)event);
            conditions.put((Object)"paths", (Object)item.getInternalPath());
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            if (item.isNode()) {
                conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames((NodeData)item.getData()));
            } else {
                conditions.put((Object)"nodeTypes", (Object)this.readNodeTypeNames(item.parentData()));
            }
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, item);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            ctx.put(InvocationContext.EVENT, event);
            this.launch(conditions, ctx);
            Object var6_5 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRemoveMixin(NodeImpl node, InternalQName mixinType) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        if (this.activeItem != null) {
            return;
        }
        this.activeItem = node;
        try {
            Condition conditions = new Condition();
            conditions.put((Object)"types", (Object)512);
            conditions.put((Object)"paths", (Object)node.getInternalPath());
            conditions.put((Object)"nodeTypes", (Object)new InternalQName[]{mixinType});
            conditions.put((Object)"workspaces", (Object)this.workspaceName);
            InvocationContext ctx = new InvocationContext();
            ctx.put(InvocationContext.CURRENT_ITEM, node);
            ctx.put(InvocationContext.EVENT, 512);
            ctx.put(InvocationContext.EXO_CONTAINER, this.container);
            this.launch(conditions, ctx);
            Object var6_5 = null;
            this.activeItem = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.activeItem = null;
            throw throwable;
        }
    }

    private InternalQName[] readNodeTypeNames(NodeData node) {
        InternalQName primaryTypeName = node.getPrimaryTypeName();
        InternalQName[] mixinNames = node.getMixinTypeNames();
        InternalQName[] nodeTypeNames = new InternalQName[mixinNames.length + 1];
        nodeTypeNames[0] = primaryTypeName;
        System.arraycopy(mixinNames, 0, nodeTypeNames, 1, mixinNames.length);
        return nodeTypeNames;
    }

    protected final void launch(Condition conditions, InvocationContext context) throws AdvancedActionException {
        Set cond = this.catalog.getActions(conditions);
        if (cond != null) {
            for (Action action : cond) {
                try {
                    action.execute((Context)context);
                }
                catch (Exception e) {
                    if (action instanceof AdvancedAction) {
                        ((AdvancedAction)action).onError(e, context);
                        continue;
                    }
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

