/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.UIScriptBBCodeContainer;
import org.exoplatform.forum.rendering.core.SupportedSyntaxes;
import org.exoplatform.forum.rendering.spi.MarkupRenderDelegate;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

public class BuildRendering {
    private static Map<String, Set<String>> codeHighlighterMap = new HashMap<String, Set<String>>();
    private static Map<String, List<String>> supportedLangs = new HashMap<String, List<String>>();
    private static final Pattern codeHighlighterPattern = Pattern.compile("(\\[code=.*?\\]|brush:.*?;)", 2);
    private static final String[] dataCodes = new String[]{"applescript|AppleScript", "actionscript3 as3|AS3", "bash shell sh|Bash", "coldfusion cf|ColdFusion", "cpp c|Cpp", "c# c-sharp csharp|CSharp", "css less|Css", "delphi pascal pas|Delphi", "diff patch|Diff", "erl erlang|Erlang", "groovy|Groovy", "haxe hx|Haxe", "java|Java", "jfx javafx|JavaFX", "js jscript javascript|JScript", "perl Perl pl|Perl", "php|Php", "text plain|Plain", "powershell ps posh|PowerShell", "py python|Python", "ruby rails ror rb|Ruby", "sass scss|Sass", "scala|Scala", "sql|Sql", "ts typescript|TypeScript", "vb vbnet|Vb", "xml xhtml xslt html|Xml"};

    public static Map<String, List<String>> getCodeSupportedLangs() {
        return supportedLangs;
    }

    protected static String processCodeHighlighter(String postContent) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Set<String> codeHighlighters = codeHighlighterMap.get(context.getUIApplication().getId());
        if (codeHighlighters == null) {
            return postContent;
        }
        Matcher m = codeHighlighterPattern.matcher(postContent);
        Map<String, List<String>> supportedLangs = BuildRendering.getCodeSupportedLangs();
        while (m.find()) {
            String g = m.group().toLowerCase();
            g = g.replace("[code=", "").replace("]", "").replace("brush:", "").replace(";", "");
            for (String lang : supportedLangs.keySet()) {
                List<String> supportType = supportedLangs.get(lang);
                if (!supportType.contains(g)) continue;
                codeHighlighters.add(lang);
            }
        }
        return postContent;
    }

    public static void startRender(WebuiRequestContext context) {
        UIApplication uiApplication = context.getUIApplication();
        codeHighlighterMap.put(uiApplication.getId(), new HashSet());
        try {
            UIScriptBBCodeContainer scriptContainer = (UIScriptBBCodeContainer)uiApplication.getChild(UIScriptBBCodeContainer.class);
            if (scriptContainer == null) {
                ((UIScriptBBCodeContainer)uiApplication.addChild(UIScriptBBCodeContainer.class, null, null)).setRendered(true);
            }
            context.addUIComponentToUpdateByAjax((UIComponent)scriptContainer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Collection<String> getCodeHighlighters(WebuiRequestContext context) {
        return codeHighlighterMap.get(context.getUIApplication().getId());
    }

    public static void endRender(WebuiRequestContext context) {
        codeHighlighterMap.remove(context.getUIApplication().getId());
    }

    static {
        for (int i = 0; i < dataCodes.length; ++i) {
            String[] langValue = dataCodes[i].split("\\|");
            supportedLangs.put(langValue[1], Arrays.asList(langValue[0].split(" ")));
        }
    }

    public static abstract class AbstractRenderDelegate<T>
    implements MarkupRenderDelegate<T> {
        public String getMarkup(T target) {
            return BuildRendering.processCodeHighlighter(CommonUtils.decodeSpecialCharToHTMLnumberIgnore(this.getMessage(target)));
        }

        public String getSyntax(T target) {
            return SupportedSyntaxes.bbcode.name();
        }

        public abstract String getMessage(T var1);
    }
}

