/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.List;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.commons.notification.impl.service.process.NotificationDaily;
import org.exoplatform.commons.notification.impl.service.process.NotificationInstantly;
import org.exoplatform.commons.notification.impl.service.process.NotificationProcess;
import org.exoplatform.commons.notification.impl.service.process.NotificationWeekly;
import org.exoplatform.commons.utils.CommonsUtils;

public class NotificationController {
    private final NotificationProcess instantly;
    public static NotificationController DEFAULT = new NotificationController();
    private final UserSettingService notificationService;
    private final NotificationDataStorage storage;

    public NotificationController() {
        NotificationDaily daily = new NotificationDaily();
        this.instantly = new NotificationInstantly();
        daily.setNext(new NotificationWeekly());
        this.instantly.setNext(daily);
        this.notificationService = CommonsUtils.getService(UserSettingService.class);
        this.storage = CommonsUtils.getService(NotificationDataStorage.class);
    }

    public void process(NotificationInfo notification) throws Exception {
        List userIds = notification.getSendToUserIds();
        for (String userId : userIds) {
            UserSetting setting = this.notificationService.get(userId);
            this.instantly.process(setting, notification);
        }
        this.save(notification);
    }

    private void save(NotificationInfo notification) throws Exception {
        if (notification.getSendToDaily().length > 0 || notification.getSendToWeekly().length > 0) {
            this.storage.save(notification);
        }
    }
}

