/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.api.notification.service.template.DigestorService;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.service.QueueMessageImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class NotificationServiceImpl
extends AbstractService
implements NotificationService {
    private static final Log LOG = ExoLogger.getLogger(NotificationServiceImpl.class);
    private final NotificationDataStorage storage;
    private final DigestorService digestorService;
    private final UserSettingService userService;

    public NotificationServiceImpl(UserSettingService userService, DigestorService digestorService, NotificationDataStorage storage) {
        this.userService = userService;
        this.digestorService = digestorService;
        this.storage = storage;
    }

    public void process(NotificationInfo notification) throws Exception {
        String pluginId = notification.getKey().getId();
        if (NotificationContextFactory.getInstance().getStatisticsService().isStatisticsEnabled()) {
            NotificationContextFactory.getInstance().getStatisticsCollector().createNotificationInfoCount(pluginId);
        }
        if (!CommonsUtils.getService(PluginSettingService.class).isActive(pluginId)) {
            return;
        }
        UserSettingService notificationService = CommonsUtils.getService(UserSettingService.class);
        List userIds = notification.getSendToUserIds();
        if (notification.isSendAll()) {
            userIds = notificationService.getUserSettingByPlugin(pluginId);
        }
        ArrayList<String> userIdPendings = new ArrayList<String>();
        for (String userId : userIds) {
            UserSetting userSetting = notificationService.get(userId);
            if (!userSetting.isActive()) continue;
            if (userSetting.isInInstantly(pluginId)) {
                this.sendInstantly(notification.clone().setTo(userId));
            }
            if (!userSetting.isActiveWithoutInstantly(pluginId)) continue;
            userIdPendings.add(userId);
            this.setValueSendbyFrequency(notification, userSetting, userId);
        }
        if (userIdPendings.size() > 0 || notification.isSendAll()) {
            notification.to(userIdPendings);
            this.storage.save(notification);
        }
    }

    private void sendInstantly(NotificationInfo notification) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        NotificationContext nCtx = NotificationContextImpl.cloneInstance();
        AbstractNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin != null) {
            nCtx.setNotificationInfo(notification);
            MessageInfo info = plugin.buildMessage(nCtx);
            if (info != null) {
                if (NotificationUtils.isValidEmailAddresses(info.getTo())) {
                    CommonsUtils.getService(QueueMessageImpl.class).sendMessage(info.makeEmailNotification());
                } else {
                    LOG.warn((Object)String.format("The email %s is not valid for sending notification", info.getTo()));
                }
                if (stats) {
                    NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(info.getPluginId());
                }
            }
        }
    }

    public void process(Collection<NotificationInfo> messages) throws Exception {
        for (NotificationInfo message : messages) {
            this.process(message);
        }
    }

    private void setValueSendbyFrequency(NotificationInfo message, UserSetting userNotificationSetting, String userId) {
        if (message.isSendAll()) {
            return;
        }
        String pluginId = message.getKey().getId();
        if (userNotificationSetting.isInDaily(pluginId)) {
            message.setSendToDaily(userId);
        }
        if (userNotificationSetting.isInWeekly(pluginId)) {
            message.setSendToWeekly(userId);
        }
    }

    public void digest(NotificationContext notifContext) throws Exception {
        List defaultMixinUsers;
        List userDigestSettings;
        UserSetting defaultConfigPlugins = this.getDefaultUserSetting(notifContext.getPluginSettingService().getActivePluginIds());
        ArrayList<UserSetting> sentUsers = new ArrayList<UserSetting>();
        long startTime = System.currentTimeMillis();
        int limit = 100;
        int offset = 0;
        while ((userDigestSettings = this.userService.getDigestSettingForAllUser(notifContext, offset, limit)).size() != 0) {
            this.send(notifContext, userDigestSettings);
            offset += limit;
            sentUsers.addAll(userDigestSettings);
        }
        LOG.debug((Object)("Time to run process users have settings: " + (System.currentTimeMillis() - startTime) + "ms."));
        long startTimeDefault = System.currentTimeMillis();
        offset = 0;
        while ((defaultMixinUsers = this.userService.getDigestDefaultSettingForAllUser(offset, limit)).size() != 0) {
            this.sendDefault(notifContext, defaultMixinUsers, defaultConfigPlugins);
            offset += limit;
            sentUsers.addAll(defaultMixinUsers);
        }
        sentUsers.addAll(this.userService.getUserSettingWithDeactivate());
        this.sendUserWithNoSetting(notifContext, defaultConfigPlugins, sentUsers);
        this.storage.removeMessageAfterSent();
        LOG.debug((Object)("Time to run process users used default settings: " + (System.currentTimeMillis() - startTimeDefault) + "ms."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUserWithNoSetting(NotificationContext context, UserSetting defaultSetting, List<UserSetting> sentUsers) throws Exception {
        OrganizationService organizationService = CommonsUtils.getService(OrganizationService.class);
        CommonsUtils.startRequest(organizationService);
        ListAccess allUsers = null;
        try {
            allUsers = organizationService.getUserHandler().findAllUsers();
        }
        finally {
            CommonsUtils.endRequest(organizationService);
        }
        int size = allUsers.getSize();
        int limit = 200;
        int index = 0;
        int length = Math.min(limit, size);
        if (size > sentUsers.size()) {
            ArrayList<User> addMixinUsers = new ArrayList<User>();
            ArrayList<UserSetting> usersDefaultSettings = new ArrayList<UserSetting>();
            while (index < size && length > 0) {
                usersDefaultSettings = new ArrayList();
                LOG.debug((Object)String.format("Load from %s to %s, length %s", index, index + length, length));
                User[] users = (User[])allUsers.load(index, length);
                if (users.length == 0) break;
                Calendar cal = Calendar.getInstance();
                for (int i = 0; i < users.length; ++i) {
                    UserSetting userSetting = UserSetting.getInstance().setUserId(users[i].getUserName());
                    if (sentUsers.contains(userSetting)) continue;
                    cal.setTime(users[i].getCreatedDate());
                    usersDefaultSettings.add(userSetting.setLastUpdateTime(cal));
                    addMixinUsers.add(users[i]);
                }
                this.sendDefault(context, usersDefaultSettings, defaultSetting);
                length = Math.min(limit, size - (index += length));
            }
            LOG.debug((Object)("Done sent notification for " + addMixinUsers.size() + " users must addMixin."));
            long startTime = System.currentTimeMillis();
            this.userService.addMixin(addMixinUsers.toArray(new User[addMixinUsers.size()]));
            LOG.debug((Object)("Done addMixin for " + addMixinUsers.size() + " users, time: " + (System.currentTimeMillis() - startTime) + "ms."));
        }
    }

    private void send(NotificationContext context, List<UserSetting> userSettings) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            MessageInfo messageInfo;
            Map notificationMessageMap;
            if (NotificationUtils.isDeletedMember(userSetting.getUserId()) || (notificationMessageMap = this.storage.getByUser(context, userSetting)).size() <= 0 || (messageInfo = this.digestorService.buildMessage(context, notificationMessageMap, userSetting)) == null) continue;
            CommonsUtils.getService(QueueMessage.class).put(messageInfo);
            if (!stats) continue;
            NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(messageInfo.getPluginId());
            NotificationContextFactory.getInstance().getStatisticsCollector().putQueue(messageInfo.getPluginId());
        }
    }

    private void sendDefault(NotificationContext context, List<UserSetting> userSettings, UserSetting defaultConfigPlugins) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            MessageInfo messageInfo;
            Map notificationMessageMap;
            if (NotificationUtils.isDeletedMember(userSetting.getUserId()) || (notificationMessageMap = this.storage.getByUser(context, userSetting = defaultConfigPlugins.clone().setUserId(userSetting.getUserId()).setLastUpdateTime(userSetting.getLastUpdateTime()))).size() <= 0 || (messageInfo = this.digestorService.buildMessage(context, notificationMessageMap, userSetting)) == null) continue;
            CommonsUtils.getService(QueueMessage.class).put(messageInfo);
            if (!stats) continue;
            NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(messageInfo.getPluginId());
            NotificationContextFactory.getInstance().getStatisticsCollector().putQueue(messageInfo.getPluginId());
        }
    }

    private UserSetting getDefaultUserSetting(List<String> activatedPluginsByAdminSetting) {
        UserSetting setting = UserSetting.getInstance();
        UserSetting defaultSetting = UserSetting.getDefaultInstance();
        for (String string : activatedPluginsByAdminSetting) {
            if (defaultSetting.isInWeekly(string)) {
                setting.addProvider(string, UserSetting.FREQUENCY.WEEKLY);
                continue;
            }
            if (!defaultSetting.isInDaily(string)) continue;
            setting.addProvider(string, UserSetting.FREQUENCY.DAILY);
        }
        return setting;
    }
}

