/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.job.mbeans;

import java.util.Date;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;

public abstract class AbstractNotificationJobManager
implements ManagementAware {
    protected ManagementContext context;
    protected static final Log LOG = ExoLogger.getLogger(AbstractNotificationJobManager.class);
    public static final String EXECUTION_COUNT = "count";
    public static final String LAST_EXECUTION_DURATION = "duration";
    public static final String DIGEST_TYPE = "digest";
    protected Scheduler scheduler = null;
    protected JobDetail job = null;
    protected TriggerKey triggerKey = null;

    public void register(Object o) {
        if (this.context != null) {
            this.context.register(o);
        }
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    @Managed
    @ManagedDescription(value="Get CronExpression of the Job.")
    @Impact(value=ImpactType.READ)
    public String getCronExpression() {
        try {
            return ((CronTrigger)this.scheduler.getTrigger(this.triggerKey)).getCronExpression();
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
            return "";
        }
    }

    @Managed
    @ManagedDescription(value="Get last execution time of the Job.")
    @Impact(value=ImpactType.READ)
    public Date getLastExecutionTime() {
        try {
            return ((CronTrigger)this.scheduler.getTrigger(this.triggerKey)).getPreviousFireTime();
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    @Managed
    @ManagedDescription(value="Get next execution time of the Job.")
    @Impact(value=ImpactType.READ)
    public Date getNextExecutionTime() {
        try {
            return ((CronTrigger)this.scheduler.getTrigger(this.triggerKey)).getNextFireTime();
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    @Managed
    @ManagedDescription(value="Get last execution duration in second.")
    @Impact(value=ImpactType.READ)
    public long getLastExecutionDuration() {
        try {
            if (this.job != null) {
                return this.scheduler.getJobDetail(this.job.getKey()).getJobDataMap().getLong(LAST_EXECUTION_DURATION);
            }
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    @Managed
    @ManagedDescription(value="Get execution counter")
    @Impact(value=ImpactType.READ)
    public int getExecutionCounter() {
        try {
            if (this.job != null) {
                return this.scheduler.getJobDetail(this.job.getKey()).getJobDataMap().getInt(EXECUTION_COUNT);
            }
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Managed
    @ManagedDescription(value="Reset execution counter")
    @Impact(value=ImpactType.READ)
    public void resetExecutionCounter() {
        this.startJob(0);
    }

    @Managed
    @ManagedDescription(value="Start Job after n second.")
    @Impact(value=ImpactType.READ)
    public void startJobAfter(int second) {
        this.startJob(second);
    }

    protected abstract void startJob(int var1);
}

