/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.util.Arrays;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.annotation.Virtual;
import nu.validator.htmlparser.impl.Portability;

public final class ElementName {
    public static final ElementName NULL_ELEMENT_NAME = new ElementName(null);
    @Local
    public final String name;
    @Local
    public final String camelCaseName;
    public final int group;
    public final boolean special;
    public final boolean scoping;
    public final boolean fosterParenting;
    public final boolean custom;
    public static final ElementName A = new ElementName("a", "a", 1, false, false, false);
    public static final ElementName B = new ElementName("b", "b", 45, false, false, false);
    public static final ElementName G = new ElementName("g", "g", 0, false, false, false);
    public static final ElementName I = new ElementName("i", "i", 45, false, false, false);
    public static final ElementName P = new ElementName("p", "p", 29, true, false, false);
    public static final ElementName Q = new ElementName("q", "q", 0, false, false, false);
    public static final ElementName S = new ElementName("s", "s", 45, false, false, false);
    public static final ElementName U = new ElementName("u", "u", 45, false, false, false);
    public static final ElementName BR = new ElementName("br", "br", 4, true, false, false);
    public static final ElementName CI = new ElementName("ci", "ci", 0, false, false, false);
    public static final ElementName CN = new ElementName("cn", "cn", 0, false, false, false);
    public static final ElementName DD = new ElementName("dd", "dd", 41, true, false, false);
    public static final ElementName DL = new ElementName("dl", "dl", 46, true, false, false);
    public static final ElementName DT = new ElementName("dt", "dt", 41, true, false, false);
    public static final ElementName EM = new ElementName("em", "em", 45, false, false, false);
    public static final ElementName EQ = new ElementName("eq", "eq", 0, false, false, false);
    public static final ElementName FN = new ElementName("fn", "fn", 0, false, false, false);
    public static final ElementName H1 = new ElementName("h1", "h1", 42, true, false, false);
    public static final ElementName H2 = new ElementName("h2", "h2", 42, true, false, false);
    public static final ElementName H3 = new ElementName("h3", "h3", 42, true, false, false);
    public static final ElementName H4 = new ElementName("h4", "h4", 42, true, false, false);
    public static final ElementName H5 = new ElementName("h5", "h5", 42, true, false, false);
    public static final ElementName H6 = new ElementName("h6", "h6", 42, true, false, false);
    public static final ElementName GT = new ElementName("gt", "gt", 0, false, false, false);
    public static final ElementName HR = new ElementName("hr", "hr", 22, true, false, false);
    public static final ElementName IN = new ElementName("in", "in", 0, false, false, false);
    public static final ElementName LI = new ElementName("li", "li", 15, true, false, false);
    public static final ElementName LN = new ElementName("ln", "ln", 0, false, false, false);
    public static final ElementName LT = new ElementName("lt", "lt", 0, false, false, false);
    public static final ElementName MI = new ElementName("mi", "mi", 57, false, false, false);
    public static final ElementName MN = new ElementName("mn", "mn", 57, false, false, false);
    public static final ElementName MO = new ElementName("mo", "mo", 57, false, false, false);
    public static final ElementName MS = new ElementName("ms", "ms", 57, false, false, false);
    public static final ElementName OL = new ElementName("ol", "ol", 46, true, false, false);
    public static final ElementName OR = new ElementName("or", "or", 0, false, false, false);
    public static final ElementName PI = new ElementName("pi", "pi", 0, false, false, false);
    public static final ElementName RP = new ElementName("rp", "rp", 53, false, false, false);
    public static final ElementName RT = new ElementName("rt", "rt", 53, false, false, false);
    public static final ElementName TD = new ElementName("td", "td", 40, false, true, false);
    public static final ElementName TH = new ElementName("th", "th", 40, false, true, false);
    public static final ElementName TR = new ElementName("tr", "tr", 37, true, false, true);
    public static final ElementName TT = new ElementName("tt", "tt", 45, false, false, false);
    public static final ElementName UL = new ElementName("ul", "ul", 46, true, false, false);
    public static final ElementName AND = new ElementName("and", "and", 0, false, false, false);
    public static final ElementName ARG = new ElementName("arg", "arg", 0, false, false, false);
    public static final ElementName ABS = new ElementName("abs", "abs", 0, false, false, false);
    public static final ElementName BIG = new ElementName("big", "big", 45, false, false, false);
    public static final ElementName BDO = new ElementName("bdo", "bdo", 0, false, false, false);
    public static final ElementName CSC = new ElementName("csc", "csc", 0, false, false, false);
    public static final ElementName COL = new ElementName("col", "col", 7, true, false, false);
    public static final ElementName COS = new ElementName("cos", "cos", 0, false, false, false);
    public static final ElementName COT = new ElementName("cot", "cot", 0, false, false, false);
    public static final ElementName DEL = new ElementName("del", "del", 0, false, false, false);
    public static final ElementName DFN = new ElementName("dfn", "dfn", 0, false, false, false);
    public static final ElementName DIR = new ElementName("dir", "dir", 51, true, false, false);
    public static final ElementName DIV = new ElementName("div", "div", 50, true, false, false);
    public static final ElementName EXP = new ElementName("exp", "exp", 0, false, false, false);
    public static final ElementName GCD = new ElementName("gcd", "gcd", 0, false, false, false);
    public static final ElementName GEQ = new ElementName("geq", "geq", 0, false, false, false);
    public static final ElementName IMG = new ElementName("img", "img", 48, true, false, false);
    public static final ElementName INS = new ElementName("ins", "ins", 0, false, false, false);
    public static final ElementName INT = new ElementName("int", "int", 0, false, false, false);
    public static final ElementName KBD = new ElementName("kbd", "kbd", 0, false, false, false);
    public static final ElementName LOG = new ElementName("log", "log", 0, false, false, false);
    public static final ElementName LCM = new ElementName("lcm", "lcm", 0, false, false, false);
    public static final ElementName LEQ = new ElementName("leq", "leq", 0, false, false, false);
    public static final ElementName MTD = new ElementName("mtd", "mtd", 0, false, false, false);
    public static final ElementName MIN = new ElementName("min", "min", 0, false, false, false);
    public static final ElementName MAP = new ElementName("map", "map", 0, false, false, false);
    public static final ElementName MTR = new ElementName("mtr", "mtr", 0, false, false, false);
    public static final ElementName MAX = new ElementName("max", "max", 0, false, false, false);
    public static final ElementName NEQ = new ElementName("neq", "neq", 0, false, false, false);
    public static final ElementName NOT = new ElementName("not", "not", 0, false, false, false);
    public static final ElementName NAV = new ElementName("nav", "nav", 51, true, false, false);
    public static final ElementName PRE = new ElementName("pre", "pre", 44, true, false, false);
    public static final ElementName REM = new ElementName("rem", "rem", 0, false, false, false);
    public static final ElementName SUB = new ElementName("sub", "sub", 52, false, false, false);
    public static final ElementName SEC = new ElementName("sec", "sec", 0, false, false, false);
    public static final ElementName SVG = new ElementName("svg", "svg", 19, false, false, false);
    public static final ElementName SUM = new ElementName("sum", "sum", 0, false, false, false);
    public static final ElementName SIN = new ElementName("sin", "sin", 0, false, false, false);
    public static final ElementName SEP = new ElementName("sep", "sep", 0, false, false, false);
    public static final ElementName SUP = new ElementName("sup", "sup", 52, false, false, false);
    public static final ElementName SET = new ElementName("set", "set", 0, false, false, false);
    public static final ElementName TAN = new ElementName("tan", "tan", 0, false, false, false);
    public static final ElementName USE = new ElementName("use", "use", 0, false, false, false);
    public static final ElementName VAR = new ElementName("var", "var", 52, false, false, false);
    public static final ElementName WBR = new ElementName("wbr", "wbr", 49, true, false, false);
    public static final ElementName XMP = new ElementName("xmp", "xmp", 38, false, false, false);
    public static final ElementName XOR = new ElementName("xor", "xor", 0, false, false, false);
    public static final ElementName AREA = new ElementName("area", "area", 49, true, false, false);
    public static final ElementName ABBR = new ElementName("abbr", "abbr", 0, false, false, false);
    public static final ElementName BASE = new ElementName("base", "base", 2, true, false, false);
    public static final ElementName BVAR = new ElementName("bvar", "bvar", 0, false, false, false);
    public static final ElementName BODY = new ElementName("body", "body", 3, true, false, false);
    public static final ElementName CARD = new ElementName("card", "card", 0, false, false, false);
    public static final ElementName CODE = new ElementName("code", "code", 45, false, false, false);
    public static final ElementName CITE = new ElementName("cite", "cite", 0, false, false, false);
    public static final ElementName CSCH = new ElementName("csch", "csch", 0, false, false, false);
    public static final ElementName COSH = new ElementName("cosh", "cosh", 0, false, false, false);
    public static final ElementName COTH = new ElementName("coth", "coth", 0, false, false, false);
    public static final ElementName CURL = new ElementName("curl", "curl", 0, false, false, false);
    public static final ElementName DESC = new ElementName("desc", "desc", 59, false, false, false);
    public static final ElementName DIFF = new ElementName("diff", "diff", 0, false, false, false);
    public static final ElementName DEFS = new ElementName("defs", "defs", 0, false, false, false);
    public static final ElementName FORM = new ElementName("form", "form", 9, true, false, false);
    public static final ElementName FONT = new ElementName("font", "font", 64, false, false, false);
    public static final ElementName GRAD = new ElementName("grad", "grad", 0, false, false, false);
    public static final ElementName HEAD = new ElementName("head", "head", 20, true, false, false);
    public static final ElementName HTML = new ElementName("html", "html", 23, false, true, false);
    public static final ElementName LINE = new ElementName("line", "line", 0, false, false, false);
    public static final ElementName LINK = new ElementName("link", "link", 16, true, false, false);
    public static final ElementName LIST = new ElementName("list", "list", 0, false, false, false);
    public static final ElementName META = new ElementName("meta", "meta", 18, true, false, false);
    public static final ElementName MSUB = new ElementName("msub", "msub", 0, false, false, false);
    public static final ElementName MODE = new ElementName("mode", "mode", 0, false, false, false);
    public static final ElementName MATH = new ElementName("math", "math", 17, false, false, false);
    public static final ElementName MARK = new ElementName("mark", "mark", 0, false, false, false);
    public static final ElementName MASK = new ElementName("mask", "mask", 0, false, false, false);
    public static final ElementName MEAN = new ElementName("mean", "mean", 0, false, false, false);
    public static final ElementName MSUP = new ElementName("msup", "msup", 0, false, false, false);
    public static final ElementName MENU = new ElementName("menu", "menu", 50, true, false, false);
    public static final ElementName MROW = new ElementName("mrow", "mrow", 0, false, false, false);
    public static final ElementName NONE = new ElementName("none", "none", 0, false, false, false);
    public static final ElementName NOBR = new ElementName("nobr", "nobr", 24, false, false, false);
    public static final ElementName NEST = new ElementName("nest", "nest", 0, false, false, false);
    public static final ElementName PATH = new ElementName("path", "path", 0, false, false, false);
    public static final ElementName PLUS = new ElementName("plus", "plus", 0, false, false, false);
    public static final ElementName RULE = new ElementName("rule", "rule", 0, false, false, false);
    public static final ElementName REAL = new ElementName("real", "real", 0, false, false, false);
    public static final ElementName RELN = new ElementName("reln", "reln", 0, false, false, false);
    public static final ElementName RECT = new ElementName("rect", "rect", 0, false, false, false);
    public static final ElementName ROOT = new ElementName("root", "root", 0, false, false, false);
    public static final ElementName RUBY = new ElementName("ruby", "ruby", 52, false, false, false);
    public static final ElementName SECH = new ElementName("sech", "sech", 0, false, false, false);
    public static final ElementName SINH = new ElementName("sinh", "sinh", 0, false, false, false);
    public static final ElementName SPAN = new ElementName("span", "span", 52, false, false, false);
    public static final ElementName SAMP = new ElementName("samp", "samp", 0, false, false, false);
    public static final ElementName STOP = new ElementName("stop", "stop", 0, false, false, false);
    public static final ElementName SDEV = new ElementName("sdev", "sdev", 0, false, false, false);
    public static final ElementName TIME = new ElementName("time", "time", 0, false, false, false);
    public static final ElementName TRUE = new ElementName("true", "true", 0, false, false, false);
    public static final ElementName TREF = new ElementName("tref", "tref", 0, false, false, false);
    public static final ElementName TANH = new ElementName("tanh", "tanh", 0, false, false, false);
    public static final ElementName TEXT = new ElementName("text", "text", 0, false, false, false);
    public static final ElementName VIEW = new ElementName("view", "view", 0, false, false, false);
    public static final ElementName ASIDE = new ElementName("aside", "aside", 51, true, false, false);
    public static final ElementName AUDIO = new ElementName("audio", "audio", 0, false, false, false);
    public static final ElementName APPLY = new ElementName("apply", "apply", 0, false, false, false);
    public static final ElementName EMBED = new ElementName("embed", "embed", 48, true, false, false);
    public static final ElementName FRAME = new ElementName("frame", "frame", 10, true, false, false);
    public static final ElementName FALSE = new ElementName("false", "false", 0, false, false, false);
    public static final ElementName FLOOR = new ElementName("floor", "floor", 0, false, false, false);
    public static final ElementName GLYPH = new ElementName("glyph", "glyph", 0, false, false, false);
    public static final ElementName HKERN = new ElementName("hkern", "hkern", 0, false, false, false);
    public static final ElementName IMAGE = new ElementName("image", "image", 12, true, false, false);
    public static final ElementName IDENT = new ElementName("ident", "ident", 0, false, false, false);
    public static final ElementName INPUT = new ElementName("input", "input", 13, true, false, false);
    public static final ElementName LABEL = new ElementName("label", "label", 62, false, false, false);
    public static final ElementName LIMIT = new ElementName("limit", "limit", 0, false, false, false);
    public static final ElementName MFRAC = new ElementName("mfrac", "mfrac", 0, false, false, false);
    public static final ElementName MPATH = new ElementName("mpath", "mpath", 0, false, false, false);
    public static final ElementName METER = new ElementName("meter", "meter", 0, false, false, false);
    public static final ElementName MOVER = new ElementName("mover", "mover", 0, false, false, false);
    public static final ElementName MINUS = new ElementName("minus", "minus", 0, false, false, false);
    public static final ElementName MROOT = new ElementName("mroot", "mroot", 0, false, false, false);
    public static final ElementName MSQRT = new ElementName("msqrt", "msqrt", 0, false, false, false);
    public static final ElementName MTEXT = new ElementName("mtext", "mtext", 57, false, false, false);
    public static final ElementName NOTIN = new ElementName("notin", "notin", 0, false, false, false);
    public static final ElementName PIECE = new ElementName("piece", "piece", 0, false, false, false);
    public static final ElementName PARAM = new ElementName("param", "param", 55, true, false, false);
    public static final ElementName POWER = new ElementName("power", "power", 0, false, false, false);
    public static final ElementName REALS = new ElementName("reals", "reals", 0, false, false, false);
    public static final ElementName STYLE = new ElementName("style", "style", 33, true, false, false);
    public static final ElementName SMALL = new ElementName("small", "small", 45, false, false, false);
    public static final ElementName THEAD = new ElementName("thead", "thead", 39, true, false, true);
    public static final ElementName TABLE = new ElementName("table", "table", 34, false, true, true);
    public static final ElementName TITLE = new ElementName("title", "title", 36, true, false, false);
    public static final ElementName TSPAN = new ElementName("tspan", "tspan", 0, false, false, false);
    public static final ElementName TIMES = new ElementName("times", "times", 0, false, false, false);
    public static final ElementName TFOOT = new ElementName("tfoot", "tfoot", 39, true, false, true);
    public static final ElementName TBODY = new ElementName("tbody", "tbody", 39, true, false, true);
    public static final ElementName UNION = new ElementName("union", "union", 0, false, false, false);
    public static final ElementName VKERN = new ElementName("vkern", "vkern", 0, false, false, false);
    public static final ElementName VIDEO = new ElementName("video", "video", 0, false, false, false);
    public static final ElementName ARCSEC = new ElementName("arcsec", "arcsec", 0, false, false, false);
    public static final ElementName ARCCSC = new ElementName("arccsc", "arccsc", 0, false, false, false);
    public static final ElementName ARCTAN = new ElementName("arctan", "arctan", 0, false, false, false);
    public static final ElementName ARCSIN = new ElementName("arcsin", "arcsin", 0, false, false, false);
    public static final ElementName ARCCOS = new ElementName("arccos", "arccos", 0, false, false, false);
    public static final ElementName APPLET = new ElementName("applet", "applet", 43, false, true, false);
    public static final ElementName ARCCOT = new ElementName("arccot", "arccot", 0, false, false, false);
    public static final ElementName APPROX = new ElementName("approx", "approx", 0, false, false, false);
    public static final ElementName BUTTON = new ElementName("button", "button", 5, false, true, false);
    public static final ElementName CIRCLE = new ElementName("circle", "circle", 0, false, false, false);
    public static final ElementName CENTER = new ElementName("center", "center", 50, true, false, false);
    public static final ElementName CURSOR = new ElementName("cursor", "cursor", 0, false, false, false);
    public static final ElementName CANVAS = new ElementName("canvas", "canvas", 0, false, false, false);
    public static final ElementName DIVIDE = new ElementName("divide", "divide", 0, false, false, false);
    public static final ElementName DEGREE = new ElementName("degree", "degree", 0, false, false, false);
    public static final ElementName DIALOG = new ElementName("dialog", "dialog", 51, true, false, false);
    public static final ElementName DOMAIN = new ElementName("domain", "domain", 0, false, false, false);
    public static final ElementName EXISTS = new ElementName("exists", "exists", 0, false, false, false);
    public static final ElementName FETILE = new ElementName("fetile", "feTile", 0, false, false, false);
    public static final ElementName FIGURE = new ElementName("figure", "figure", 51, true, false, false);
    public static final ElementName FORALL = new ElementName("forall", "forall", 0, false, false, false);
    public static final ElementName FILTER = new ElementName("filter", "filter", 0, false, false, false);
    public static final ElementName FOOTER = new ElementName("footer", "footer", 51, true, false, false);
    public static final ElementName HEADER = new ElementName("header", "header", 51, true, false, false);
    public static final ElementName IFRAME = new ElementName("iframe", "iframe", 47, true, false, false);
    public static final ElementName KEYGEN = new ElementName("keygen", "keygen", 65, true, false, false);
    public static final ElementName LAMBDA = new ElementName("lambda", "lambda", 0, false, false, false);
    public static final ElementName LEGEND = new ElementName("legend", "legend", 0, false, false, false);
    public static final ElementName MSPACE = new ElementName("mspace", "mspace", 0, false, false, false);
    public static final ElementName MTABLE = new ElementName("mtable", "mtable", 0, false, false, false);
    public static final ElementName MSTYLE = new ElementName("mstyle", "mstyle", 0, false, false, false);
    public static final ElementName MGLYPH = new ElementName("mglyph", "mglyph", 56, false, false, false);
    public static final ElementName MEDIAN = new ElementName("median", "median", 0, false, false, false);
    public static final ElementName MUNDER = new ElementName("munder", "munder", 0, false, false, false);
    public static final ElementName MARKER = new ElementName("marker", "marker", 0, false, false, false);
    public static final ElementName MERROR = new ElementName("merror", "merror", 0, false, false, false);
    public static final ElementName MOMENT = new ElementName("moment", "moment", 0, false, false, false);
    public static final ElementName MATRIX = new ElementName("matrix", "matrix", 0, false, false, false);
    public static final ElementName OPTION = new ElementName("option", "option", 28, true, false, false);
    public static final ElementName OBJECT = new ElementName("object", "object", 63, false, true, false);
    public static final ElementName OUTPUT = new ElementName("output", "output", 62, false, false, false);
    public static final ElementName PRIMES = new ElementName("primes", "primes", 0, false, false, false);
    public static final ElementName SOURCE = new ElementName("source", "source", 55, false, false, false);
    public static final ElementName STRIKE = new ElementName("strike", "strike", 45, false, false, false);
    public static final ElementName STRONG = new ElementName("strong", "strong", 45, false, false, false);
    public static final ElementName SWITCH = new ElementName("switch", "switch", 0, false, false, false);
    public static final ElementName SYMBOL = new ElementName("symbol", "symbol", 0, false, false, false);
    public static final ElementName SPACER = new ElementName("spacer", "spacer", 49, true, false, false);
    public static final ElementName SELECT = new ElementName("select", "select", 32, true, false, false);
    public static final ElementName SUBSET = new ElementName("subset", "subset", 0, false, false, false);
    public static final ElementName SCRIPT = new ElementName("script", "script", 31, true, false, false);
    public static final ElementName TBREAK = new ElementName("tbreak", "tbreak", 0, false, false, false);
    public static final ElementName VECTOR = new ElementName("vector", "vector", 0, false, false, false);
    public static final ElementName ARTICLE = new ElementName("article", "article", 51, true, false, false);
    public static final ElementName ANIMATE = new ElementName("animate", "animate", 0, false, false, false);
    public static final ElementName ARCSECH = new ElementName("arcsech", "arcsech", 0, false, false, false);
    public static final ElementName ARCCSCH = new ElementName("arccsch", "arccsch", 0, false, false, false);
    public static final ElementName ARCTANH = new ElementName("arctanh", "arctanh", 0, false, false, false);
    public static final ElementName ARCSINH = new ElementName("arcsinh", "arcsinh", 0, false, false, false);
    public static final ElementName ARCCOSH = new ElementName("arccosh", "arccosh", 0, false, false, false);
    public static final ElementName ARCCOTH = new ElementName("arccoth", "arccoth", 0, false, false, false);
    public static final ElementName ACRONYM = new ElementName("acronym", "acronym", 0, false, false, false);
    public static final ElementName ADDRESS = new ElementName("address", "address", 51, true, false, false);
    public static final ElementName BGSOUND = new ElementName("bgsound", "bgsound", 49, true, false, false);
    public static final ElementName COMMAND = new ElementName("command", "command", 54, true, false, false);
    public static final ElementName COMPOSE = new ElementName("compose", "compose", 0, false, false, false);
    public static final ElementName CEILING = new ElementName("ceiling", "ceiling", 0, false, false, false);
    public static final ElementName CSYMBOL = new ElementName("csymbol", "csymbol", 0, false, false, false);
    public static final ElementName CAPTION = new ElementName("caption", "caption", 6, false, true, false);
    public static final ElementName DISCARD = new ElementName("discard", "discard", 0, false, false, false);
    public static final ElementName DECLARE = new ElementName("declare", "declare", 0, false, false, false);
    public static final ElementName DETAILS = new ElementName("details", "details", 51, true, false, false);
    public static final ElementName ELLIPSE = new ElementName("ellipse", "ellipse", 0, false, false, false);
    public static final ElementName FEFUNCA = new ElementName("fefunca", "feFuncA", 0, false, false, false);
    public static final ElementName FEFUNCB = new ElementName("fefuncb", "feFuncB", 0, false, false, false);
    public static final ElementName FEBLEND = new ElementName("feblend", "feBlend", 0, false, false, false);
    public static final ElementName FEFLOOD = new ElementName("feflood", "feFlood", 0, false, false, false);
    public static final ElementName FEIMAGE = new ElementName("feimage", "feImage", 0, false, false, false);
    public static final ElementName FEMERGE = new ElementName("femerge", "feMerge", 0, false, false, false);
    public static final ElementName FEFUNCG = new ElementName("fefuncg", "feFuncG", 0, false, false, false);
    public static final ElementName FEFUNCR = new ElementName("fefuncr", "feFuncR", 0, false, false, false);
    public static final ElementName HANDLER = new ElementName("handler", "handler", 0, false, false, false);
    public static final ElementName INVERSE = new ElementName("inverse", "inverse", 0, false, false, false);
    public static final ElementName IMPLIES = new ElementName("implies", "implies", 0, false, false, false);
    public static final ElementName ISINDEX = new ElementName("isindex", "isindex", 14, true, false, false);
    public static final ElementName LOGBASE = new ElementName("logbase", "logbase", 0, false, false, false);
    public static final ElementName LISTING = new ElementName("listing", "listing", 44, true, false, false);
    public static final ElementName MFENCED = new ElementName("mfenced", "mfenced", 0, false, false, false);
    public static final ElementName MPADDED = new ElementName("mpadded", "mpadded", 0, false, false, false);
    public static final ElementName MARQUEE = new ElementName("marquee", "marquee", 43, false, true, false);
    public static final ElementName MACTION = new ElementName("maction", "maction", 0, false, false, false);
    public static final ElementName MSUBSUP = new ElementName("msubsup", "msubsup", 0, false, false, false);
    public static final ElementName NOEMBED = new ElementName("noembed", "noembed", 60, true, false, false);
    public static final ElementName POLYGON = new ElementName("polygon", "polygon", 0, false, false, false);
    public static final ElementName PATTERN = new ElementName("pattern", "pattern", 0, false, false, false);
    public static final ElementName PRODUCT = new ElementName("product", "product", 0, false, false, false);
    public static final ElementName SETDIFF = new ElementName("setdiff", "setdiff", 0, false, false, false);
    public static final ElementName SECTION = new ElementName("section", "section", 51, true, false, false);
    public static final ElementName TENDSTO = new ElementName("tendsto", "tendsto", 0, false, false, false);
    public static final ElementName UPLIMIT = new ElementName("uplimit", "uplimit", 0, false, false, false);
    public static final ElementName ALTGLYPH = new ElementName("altglyph", "altGlyph", 0, false, false, false);
    public static final ElementName BASEFONT = new ElementName("basefont", "basefont", 49, true, false, false);
    public static final ElementName CLIPPATH = new ElementName("clippath", "clipPath", 0, false, false, false);
    public static final ElementName CODOMAIN = new ElementName("codomain", "codomain", 0, false, false, false);
    public static final ElementName COLGROUP = new ElementName("colgroup", "colgroup", 8, true, false, false);
    public static final ElementName DATAGRID = new ElementName("datagrid", "datagrid", 51, true, false, false);
    public static final ElementName EMPTYSET = new ElementName("emptyset", "emptyset", 0, false, false, false);
    public static final ElementName FACTOROF = new ElementName("factorof", "factorof", 0, false, false, false);
    public static final ElementName FIELDSET = new ElementName("fieldset", "fieldset", 61, true, false, false);
    public static final ElementName FRAMESET = new ElementName("frameset", "frameset", 11, true, false, false);
    public static final ElementName FEOFFSET = new ElementName("feoffset", "feOffset", 0, false, false, false);
    public static final ElementName GLYPHREF = new ElementName("glyphref", "glyphRef", 0, false, false, false);
    public static final ElementName INTERVAL = new ElementName("interval", "interval", 0, false, false, false);
    public static final ElementName INTEGERS = new ElementName("integers", "integers", 0, false, false, false);
    public static final ElementName INFINITY = new ElementName("infinity", "infinity", 0, false, false, false);
    public static final ElementName LISTENER = new ElementName("listener", "listener", 0, false, false, false);
    public static final ElementName LOWLIMIT = new ElementName("lowlimit", "lowlimit", 0, false, false, false);
    public static final ElementName METADATA = new ElementName("metadata", "metadata", 0, false, false, false);
    public static final ElementName MENCLOSE = new ElementName("menclose", "menclose", 0, false, false, false);
    public static final ElementName MPHANTOM = new ElementName("mphantom", "mphantom", 0, false, false, false);
    public static final ElementName NOFRAMES = new ElementName("noframes", "noframes", 25, true, false, false);
    public static final ElementName NOSCRIPT = new ElementName("noscript", "noscript", 26, true, false, false);
    public static final ElementName OPTGROUP = new ElementName("optgroup", "optgroup", 27, true, false, false);
    public static final ElementName POLYLINE = new ElementName("polyline", "polyline", 0, false, false, false);
    public static final ElementName PREFETCH = new ElementName("prefetch", "prefetch", 0, false, false, false);
    public static final ElementName PROGRESS = new ElementName("progress", "progress", 0, false, false, false);
    public static final ElementName PRSUBSET = new ElementName("prsubset", "prsubset", 0, false, false, false);
    public static final ElementName QUOTIENT = new ElementName("quotient", "quotient", 0, false, false, false);
    public static final ElementName SELECTOR = new ElementName("selector", "selector", 0, false, false, false);
    public static final ElementName TEXTAREA = new ElementName("textarea", "textarea", 35, true, false, false);
    public static final ElementName TEXTPATH = new ElementName("textpath", "textPath", 0, false, false, false);
    public static final ElementName VARIANCE = new ElementName("variance", "variance", 0, false, false, false);
    public static final ElementName ANIMATION = new ElementName("animation", "animation", 0, false, false, false);
    public static final ElementName CONJUGATE = new ElementName("conjugate", "conjugate", 0, false, false, false);
    public static final ElementName CONDITION = new ElementName("condition", "condition", 0, false, false, false);
    public static final ElementName COMPLEXES = new ElementName("complexes", "complexes", 0, false, false, false);
    public static final ElementName FONT_FACE = new ElementName("font-face", "font-face", 0, false, false, false);
    public static final ElementName FACTORIAL = new ElementName("factorial", "factorial", 0, false, false, false);
    public static final ElementName INTERSECT = new ElementName("intersect", "intersect", 0, false, false, false);
    public static final ElementName IMAGINARY = new ElementName("imaginary", "imaginary", 0, false, false, false);
    public static final ElementName LAPLACIAN = new ElementName("laplacian", "laplacian", 0, false, false, false);
    public static final ElementName MATRIXROW = new ElementName("matrixrow", "matrixrow", 0, false, false, false);
    public static final ElementName NOTSUBSET = new ElementName("notsubset", "notsubset", 0, false, false, false);
    public static final ElementName OTHERWISE = new ElementName("otherwise", "otherwise", 0, false, false, false);
    public static final ElementName PIECEWISE = new ElementName("piecewise", "piecewise", 0, false, false, false);
    public static final ElementName PLAINTEXT = new ElementName("plaintext", "plaintext", 30, true, false, false);
    public static final ElementName RATIONALS = new ElementName("rationals", "rationals", 0, false, false, false);
    public static final ElementName SEMANTICS = new ElementName("semantics", "semantics", 0, false, false, false);
    public static final ElementName TRANSPOSE = new ElementName("transpose", "transpose", 0, false, false, false);
    public static final ElementName ANNOTATION = new ElementName("annotation", "annotation", 0, false, false, false);
    public static final ElementName BLOCKQUOTE = new ElementName("blockquote", "blockquote", 50, true, false, false);
    public static final ElementName DIVERGENCE = new ElementName("divergence", "divergence", 0, false, false, false);
    public static final ElementName EULERGAMMA = new ElementName("eulergamma", "eulergamma", 0, false, false, false);
    public static final ElementName EQUIVALENT = new ElementName("equivalent", "equivalent", 0, false, false, false);
    public static final ElementName IMAGINARYI = new ElementName("imaginaryi", "imaginaryi", 0, false, false, false);
    public static final ElementName MALIGNMARK = new ElementName("malignmark", "malignmark", 56, false, false, false);
    public static final ElementName MUNDEROVER = new ElementName("munderover", "munderover", 0, false, false, false);
    public static final ElementName MLABELEDTR = new ElementName("mlabeledtr", "mlabeledtr", 0, false, false, false);
    public static final ElementName NOTANUMBER = new ElementName("notanumber", "notanumber", 0, false, false, false);
    public static final ElementName SOLIDCOLOR = new ElementName("solidcolor", "solidcolor", 0, false, false, false);
    public static final ElementName ALTGLYPHDEF = new ElementName("altglyphdef", "altGlyphDef", 0, false, false, false);
    public static final ElementName DETERMINANT = new ElementName("determinant", "determinant", 0, false, false, false);
    public static final ElementName EVENTSOURCE = new ElementName("eventsource", "eventsource", 54, true, false, false);
    public static final ElementName FEMERGENODE = new ElementName("femergenode", "feMergeNode", 0, false, false, false);
    public static final ElementName FECOMPOSITE = new ElementName("fecomposite", "feComposite", 0, false, false, false);
    public static final ElementName FESPOTLIGHT = new ElementName("fespotlight", "feSpotLight", 0, false, false, false);
    public static final ElementName MALIGNGROUP = new ElementName("maligngroup", "maligngroup", 0, false, false, false);
    public static final ElementName MPRESCRIPTS = new ElementName("mprescripts", "mprescripts", 0, false, false, false);
    public static final ElementName MOMENTABOUT = new ElementName("momentabout", "momentabout", 0, false, false, false);
    public static final ElementName NOTPRSUBSET = new ElementName("notprsubset", "notprsubset", 0, false, false, false);
    public static final ElementName PARTIALDIFF = new ElementName("partialdiff", "partialdiff", 0, false, false, false);
    public static final ElementName ALTGLYPHITEM = new ElementName("altglyphitem", "altGlyphItem", 0, false, false, false);
    public static final ElementName ANIMATECOLOR = new ElementName("animatecolor", "animateColor", 0, false, false, false);
    public static final ElementName DATATEMPLATE = new ElementName("datatemplate", "datatemplate", 0, false, false, false);
    public static final ElementName EXPONENTIALE = new ElementName("exponentiale", "exponentiale", 0, false, false, false);
    public static final ElementName FETURBULENCE = new ElementName("feturbulence", "feTurbulence", 0, false, false, false);
    public static final ElementName FEPOINTLIGHT = new ElementName("fepointlight", "fePointLight", 0, false, false, false);
    public static final ElementName FEMORPHOLOGY = new ElementName("femorphology", "feMorphology", 0, false, false, false);
    public static final ElementName OUTERPRODUCT = new ElementName("outerproduct", "outerproduct", 0, false, false, false);
    public static final ElementName ANIMATEMOTION = new ElementName("animatemotion", "animateMotion", 0, false, false, false);
    public static final ElementName COLOR_PROFILE = new ElementName("color-profile", "color-profile", 0, false, false, false);
    public static final ElementName FONT_FACE_SRC = new ElementName("font-face-src", "font-face-src", 0, false, false, false);
    public static final ElementName FONT_FACE_URI = new ElementName("font-face-uri", "font-face-uri", 0, false, false, false);
    public static final ElementName FOREIGNOBJECT = new ElementName("foreignobject", "foreignObject", 59, false, false, false);
    public static final ElementName FECOLORMATRIX = new ElementName("fecolormatrix", "feColorMatrix", 0, false, false, false);
    public static final ElementName MISSING_GLYPH = new ElementName("missing-glyph", "missing-glyph", 0, false, false, false);
    public static final ElementName MMULTISCRIPTS = new ElementName("mmultiscripts", "mmultiscripts", 0, false, false, false);
    public static final ElementName SCALARPRODUCT = new ElementName("scalarproduct", "scalarproduct", 0, false, false, false);
    public static final ElementName VECTORPRODUCT = new ElementName("vectorproduct", "vectorproduct", 0, false, false, false);
    public static final ElementName ANNOTATION_XML = new ElementName("annotation-xml", "annotation-xml", 58, false, false, false);
    public static final ElementName DEFINITION_SRC = new ElementName("definition-src", "definition-src", 0, false, false, false);
    public static final ElementName FONT_FACE_NAME = new ElementName("font-face-name", "font-face-name", 0, false, false, false);
    public static final ElementName FEGAUSSIANBLUR = new ElementName("fegaussianblur", "feGaussianBlur", 0, false, false, false);
    public static final ElementName FEDISTANTLIGHT = new ElementName("fedistantlight", "feDistantLight", 0, false, false, false);
    public static final ElementName LINEARGRADIENT = new ElementName("lineargradient", "linearGradient", 0, false, false, false);
    public static final ElementName NATURALNUMBERS = new ElementName("naturalnumbers", "naturalnumbers", 0, false, false, false);
    public static final ElementName RADIALGRADIENT = new ElementName("radialgradient", "radialGradient", 0, false, false, false);
    public static final ElementName ANIMATETRANSFORM = new ElementName("animatetransform", "animateTransform", 0, false, false, false);
    public static final ElementName CARTESIANPRODUCT = new ElementName("cartesianproduct", "cartesianproduct", 0, false, false, false);
    public static final ElementName FONT_FACE_FORMAT = new ElementName("font-face-format", "font-face-format", 0, false, false, false);
    public static final ElementName FECONVOLVEMATRIX = new ElementName("feconvolvematrix", "feConvolveMatrix", 0, false, false, false);
    public static final ElementName FEDIFFUSELIGHTING = new ElementName("fediffuselighting", "feDiffuseLighting", 0, false, false, false);
    public static final ElementName FEDISPLACEMENTMAP = new ElementName("fedisplacementmap", "feDisplacementMap", 0, false, false, false);
    public static final ElementName FESPECULARLIGHTING = new ElementName("fespecularlighting", "feSpecularLighting", 0, false, false, false);
    public static final ElementName DOMAINOFAPPLICATION = new ElementName("domainofapplication", "domainofapplication", 0, false, false, false);
    public static final ElementName FECOMPONENTTRANSFER = new ElementName("fecomponenttransfer", "feComponentTransfer", 0, false, false, false);
    @NoLength
    private static final ElementName[] ELEMENT_NAMES = new ElementName[]{A, B, G, I, P, Q, S, U, BR, CI, CN, DD, DL, DT, EM, EQ, FN, H1, H2, H3, H4, H5, H6, GT, HR, IN, LI, LN, LT, MI, MN, MO, MS, OL, OR, PI, RP, RT, TD, TH, TR, TT, UL, AND, ARG, ABS, BIG, BDO, CSC, COL, COS, COT, DEL, DFN, DIR, DIV, EXP, GCD, GEQ, IMG, INS, INT, KBD, LOG, LCM, LEQ, MTD, MIN, MAP, MTR, MAX, NEQ, NOT, NAV, PRE, REM, SUB, SEC, SVG, SUM, SIN, SEP, SUP, SET, TAN, USE, VAR, WBR, XMP, XOR, AREA, ABBR, BASE, BVAR, BODY, CARD, CODE, CITE, CSCH, COSH, COTH, CURL, DESC, DIFF, DEFS, FORM, FONT, GRAD, HEAD, HTML, LINE, LINK, LIST, META, MSUB, MODE, MATH, MARK, MASK, MEAN, MSUP, MENU, MROW, NONE, NOBR, NEST, PATH, PLUS, RULE, REAL, RELN, RECT, ROOT, RUBY, SECH, SINH, SPAN, SAMP, STOP, SDEV, TIME, TRUE, TREF, TANH, TEXT, VIEW, ASIDE, AUDIO, APPLY, EMBED, FRAME, FALSE, FLOOR, GLYPH, HKERN, IMAGE, IDENT, INPUT, LABEL, LIMIT, MFRAC, MPATH, METER, MOVER, MINUS, MROOT, MSQRT, MTEXT, NOTIN, PIECE, PARAM, POWER, REALS, STYLE, SMALL, THEAD, TABLE, TITLE, TSPAN, TIMES, TFOOT, TBODY, UNION, VKERN, VIDEO, ARCSEC, ARCCSC, ARCTAN, ARCSIN, ARCCOS, APPLET, ARCCOT, APPROX, BUTTON, CIRCLE, CENTER, CURSOR, CANVAS, DIVIDE, DEGREE, DIALOG, DOMAIN, EXISTS, FETILE, FIGURE, FORALL, FILTER, FOOTER, HEADER, IFRAME, KEYGEN, LAMBDA, LEGEND, MSPACE, MTABLE, MSTYLE, MGLYPH, MEDIAN, MUNDER, MARKER, MERROR, MOMENT, MATRIX, OPTION, OBJECT, OUTPUT, PRIMES, SOURCE, STRIKE, STRONG, SWITCH, SYMBOL, SPACER, SELECT, SUBSET, SCRIPT, TBREAK, VECTOR, ARTICLE, ANIMATE, ARCSECH, ARCCSCH, ARCTANH, ARCSINH, ARCCOSH, ARCCOTH, ACRONYM, ADDRESS, BGSOUND, COMMAND, COMPOSE, CEILING, CSYMBOL, CAPTION, DISCARD, DECLARE, DETAILS, ELLIPSE, FEFUNCA, FEFUNCB, FEBLEND, FEFLOOD, FEIMAGE, FEMERGE, FEFUNCG, FEFUNCR, HANDLER, INVERSE, IMPLIES, ISINDEX, LOGBASE, LISTING, MFENCED, MPADDED, MARQUEE, MACTION, MSUBSUP, NOEMBED, POLYGON, PATTERN, PRODUCT, SETDIFF, SECTION, TENDSTO, UPLIMIT, ALTGLYPH, BASEFONT, CLIPPATH, CODOMAIN, COLGROUP, DATAGRID, EMPTYSET, FACTOROF, FIELDSET, FRAMESET, FEOFFSET, GLYPHREF, INTERVAL, INTEGERS, INFINITY, LISTENER, LOWLIMIT, METADATA, MENCLOSE, MPHANTOM, NOFRAMES, NOSCRIPT, OPTGROUP, POLYLINE, PREFETCH, PROGRESS, PRSUBSET, QUOTIENT, SELECTOR, TEXTAREA, TEXTPATH, VARIANCE, ANIMATION, CONJUGATE, CONDITION, COMPLEXES, FONT_FACE, FACTORIAL, INTERSECT, IMAGINARY, LAPLACIAN, MATRIXROW, NOTSUBSET, OTHERWISE, PIECEWISE, PLAINTEXT, RATIONALS, SEMANTICS, TRANSPOSE, ANNOTATION, BLOCKQUOTE, DIVERGENCE, EULERGAMMA, EQUIVALENT, IMAGINARYI, MALIGNMARK, MUNDEROVER, MLABELEDTR, NOTANUMBER, SOLIDCOLOR, ALTGLYPHDEF, DETERMINANT, EVENTSOURCE, FEMERGENODE, FECOMPOSITE, FESPOTLIGHT, MALIGNGROUP, MPRESCRIPTS, MOMENTABOUT, NOTPRSUBSET, PARTIALDIFF, ALTGLYPHITEM, ANIMATECOLOR, DATATEMPLATE, EXPONENTIALE, FETURBULENCE, FEPOINTLIGHT, FEMORPHOLOGY, OUTERPRODUCT, ANIMATEMOTION, COLOR_PROFILE, FONT_FACE_SRC, FONT_FACE_URI, FOREIGNOBJECT, FECOLORMATRIX, MISSING_GLYPH, MMULTISCRIPTS, SCALARPRODUCT, VECTORPRODUCT, ANNOTATION_XML, DEFINITION_SRC, FONT_FACE_NAME, FEGAUSSIANBLUR, FEDISTANTLIGHT, LINEARGRADIENT, NATURALNUMBERS, RADIALGRADIENT, ANIMATETRANSFORM, CARTESIANPRODUCT, FONT_FACE_FORMAT, FECONVOLVEMATRIX, FEDIFFUSELIGHTING, FEDISPLACEMENTMAP, FESPECULARLIGHTING, DOMAINOFAPPLICATION, FECOMPONENTTRANSFER};
    private static final int[] ELEMENT_HASHES = new int[]{1057, 1090, 1255, 1321, 1552, 1585, 1651, 1717, 68162, 68899, 69059, 69764, 70020, 70276, 71077, 71205, 72134, 72232, 72264, 72296, 72328, 72360, 72392, 73351, 74312, 75209, 78124, 78284, 78476, 79149, 79309, 79341, 79469, 81295, 81487, 82224, 84498, 84626, 86164, 86292, 86612, 86676, 87445, 3183041, 3186241, 3198017, 3218722, 3226754, 3247715, 3256803, 3263971, 3264995, 3289252, 3291332, 3295524, 3299620, 3326725, 3379303, 3392679, 3448233, 3460553, 3461577, 3510347, 3546604, 3552364, 3556524, 3576461, 3586349, 3588141, 3590797, 3596333, 3622062, 3625454, 3627054, 3675728, 3749042, 3771059, 3771571, 3776211, 3782323, 0x39B933, 3784883, 3785395, 3788979, 3815476, 3839605, 3885110, 3917911, 3948984, 3951096, 135304769, 135858241, 0x822CC22, 136906434, 137138658, 137512995, 137531875, 137548067, 137629283, 137645539, 137646563, 137775779, 138529956, 138615076, 139040932, 140954086, 141179366, 141690439, 142738600, 0x8863688, 146979116, 147175724, 147475756, 147902637, 147936877, 148017645, 148131885, 148228141, 148229165, 148309165, 148395629, 148551853, 148618829, 149076462, 149490158, 149572782, 151277616, 151639440, 0x922B2B2, 153486514, 153563314, 153750706, 153763314, 153914034, 154406067, 0x9343933, 154600979, 154678323, 154680979, 154866835, 155366708, 155375188, 155391572, 155465780, 155869364, 158045494, 168988979, 169321621, 169652752, 173151309, 174240818, 174247297, 174669292, 175391532, 176638123, 177380397, 177879204, 177886734, 180753473, 181020073, 181503558, 181686320, 181999237, 181999311, 182048201, 182074866, 182078003, 182083764, 182920847, 184716457, 184976961, 185145071, 187281445, 187872052, 188100653, 188875944, 188919873, 188920457, 189203987, 189371817, 189414886, 189567458, 190266670, 191318187, 191337609, 202479203, 202493027, 202835587, 202843747, 203013219, 203036048, 203045987, 203177552, 203898516, 204648562, 205067918, 205078130, 205096654, 205689142, 205690439, 205766017, 205988909, 207213161, 207794484, 207800999, 208023602, 208213644, 208213647, 210310273, 210940978, 213325049, 213946445, 214055079, 215125040, 215134273, 215135028, 215237420, 215418148, 215553166, 215553394, 215563858, 215627949, 215754324, 217529652, 217713834, 217732628, 218731945, 221417045, 221424946, 221493746, 221515401, 221658189, 221844577, 221908140, 221910626, 221921586, 222659762, 225001091, 236105833, 236113965, 236194995, 236195427, 236206132, 236206387, 236211683, 236212707, 236381647, 236571826, 237124271, 238172205, 238210544, 238270764, 238435405, 238501172, 239224867, 239257644, 239710497, 240307721, 241208789, 241241557, 241318060, 241319404, 241343533, 241344069, 241405397, 241765845, 243864964, 244502085, 244946220, 245109902, 0xEC2CC22, 247707956, 248648814, 248648836, 248682161, 248986932, 249058914, 249697357, 252132601, 252135604, 252317348, 255007012, 255278388, 256365156, 257566121, 269763372, 271202790, 271863856, 272049197, 272127474, 272770631, 274339449, 274939471, 275388004, 275388005, 275388006, 275977800, 278267602, 278513831, 278712622, 281613765, 281683369, 282120228, 282250732, 282508942, 283743649, 283787570, 284710386, 285391148, 285478533, 285854898, 285873762, 286931113, 288964227, 289445441, 289689648, 291671489, 303512884, 305319975, 305610036, 305764101, 308448294, 308675890, 312085683, 312264750, 315032867, 316391000, 317331042, 317902135, 318950711, 319447220, 321499182, 322538804, 323145200, 337067316, 337826293, 339905989, 340833697, 341457068, 345302593, 349554733, 349771471, 349786245, 350819405, 356072847, 370349192, 373962798, 374509141, 375558638, 375574835, 376053993, 383276530, 383373833, 383407586, 384439906, 386079012, 404133513, 404307343, 407031852, 408072233, 409112005, 409608425, 409771500, 419040932, 437730612, 439529766, 442616365, 442813037, 443157674, 443295316, 450118444, 450482697, 456789668, 459935396, 471217869, 474073645, 476230702, 476665218, 476717289, 483014825, 485083298, 489306281, 538364390, 540675748, 543819186, 543958612, 576960820, 577242548, 610515252, 642202932, 644420819};

    public static ElementName elementNameByString(String name) {
        int hash = ElementName.stringToHash(name);
        int index = Arrays.binarySearch(ELEMENT_HASHES, hash);
        if (index < 0) {
            return new ElementName(name);
        }
        ElementName rv = ELEMENT_NAMES[index];
        if (!name.equals(rv.name)) {
            return new ElementName(name);
        }
        return rv;
    }

    static ElementName elementNameByBuffer(char[] buf, int offset, int length) {
        int hash = ElementName.bufToHash(buf, length);
        int index = Arrays.binarySearch(ELEMENT_HASHES, hash);
        if (index < 0) {
            return new ElementName(Portability.newLocalNameFromBuffer(buf, offset, length));
        }
        ElementName rv = ELEMENT_NAMES[index];
        String name = rv.name;
        if (!Portability.localEqualsBuffer(name, buf, offset, length)) {
            return new ElementName(Portability.newLocalNameFromBuffer(buf, offset, length));
        }
        return rv;
    }

    private static int bufToHash(char[] buf, int len) {
        int hash = len;
        hash <<= 5;
        hash += buf[0] - 96;
        int j = len;
        for (int i = 0; i < 4 && j > 0; ++i) {
            hash <<= 5;
            hash += buf[--j] - 96;
        }
        return hash;
    }

    private static int stringToHash(String s) {
        int len;
        int hash = len = s.length();
        hash <<= 5;
        hash += s.charAt(0) - 96;
        int j = len;
        for (int i = 0; i < 4 && j > 0; ++i) {
            hash <<= 5;
            hash += s.charAt(--j) - 96;
        }
        return hash;
    }

    private ElementName(@Local String name, @Local String camelCaseName, int group, boolean special, boolean scoping, boolean fosterParenting) {
        this.name = name;
        this.camelCaseName = camelCaseName;
        this.group = group;
        this.special = special;
        this.scoping = scoping;
        this.fosterParenting = fosterParenting;
        this.custom = false;
    }

    protected ElementName(@Local String name) {
        this.name = name;
        this.camelCaseName = name;
        this.group = 0;
        this.special = false;
        this.scoping = false;
        this.fosterParenting = false;
        this.custom = true;
    }

    @Virtual
    void release() {
    }

    private void destructor() {
        Portability.releaseLocal(this.name);
    }
}

