/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.ConnectionFilterListAccess;
import org.exoplatform.social.core.identity.ConnectionListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.RelationshipLifeCycle;
import org.exoplatform.social.core.relationship.RelationshipListener;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class RelationshipManagerImpl
implements RelationshipManager {
    protected RelationshipStorage storage;
    protected RelationshipLifeCycle lifeCycle = new RelationshipLifeCycle();
    private IdentityManager identityManager;
    protected static final int OFFSET = 0;
    protected static final int LIMIT = 200;

    public RelationshipManagerImpl(RelationshipStorage relationshipStorage) {
        this.storage = relationshipStorage;
    }

    @Override
    public Relationship get(String relationshipId) {
        Relationship relationship = null;
        try {
            relationship = this.storage.getRelationship(relationshipId);
        }
        catch (Exception e) {
            return null;
        }
        return relationship;
    }

    @Override
    public Relationship invite(Identity sender, Identity receiver) throws RelationshipStorageException {
        return this.inviteToConnect(sender, receiver);
    }

    @Override
    public void save(Relationship relationship) throws RelationshipStorageException {
        this.update(relationship);
    }

    @Override
    public void confirm(Relationship relationship) throws RelationshipStorageException {
        this.confirm(relationship.getReceiver(), relationship.getSender());
    }

    @Override
    public void deny(Relationship relationship) throws RelationshipStorageException {
        this.deny(relationship.getReceiver(), relationship.getSender());
    }

    @Override
    public void remove(Relationship relationship) throws RelationshipStorageException {
        this.delete(relationship);
    }

    @Override
    public void ignore(Relationship relationship) throws RelationshipStorageException {
        this.ignore(relationship.getSender(), relationship.getReceiver());
    }

    @Override
    public List<Relationship> getPending(Identity sender) throws RelationshipStorageException {
        return this.getSender(sender, Relationship.Type.PENDING, null);
    }

    @Override
    public List<Relationship> getPending(Identity sender, List<Identity> identities) throws RelationshipStorageException {
        return this.getSender(sender, Relationship.Type.PENDING, identities);
    }

    @Override
    public List<Relationship> getIncoming(Identity receiver) throws RelationshipStorageException {
        return this.getReceiver(receiver, Relationship.Type.PENDING, null);
    }

    @Override
    public List<Relationship> getIncoming(Identity receiver, List<Identity> identities) throws RelationshipStorageException {
        return this.getReceiver(receiver, Relationship.Type.PENDING, identities);
    }

    @Override
    public List<Relationship> getConfirmed(Identity identity) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.CONFIRMED, null);
    }

    @Override
    public List<Relationship> getConfirmed(Identity identity, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.CONFIRMED, identities);
    }

    @Override
    public List<Relationship> getAll(Identity identity) throws RelationshipStorageException {
        return this.getRelationships(identity, null, null);
    }

    @Override
    public List<Relationship> getAll(Identity identity, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, null, identities);
    }

    @Override
    public List<Relationship> getAll(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, type, identities);
    }

    @Override
    public Relationship get(Identity identity1, Identity identity2) throws RelationshipStorageException {
        return this.storage.getRelationship(identity1, identity2);
    }

    @Override
    public Relationship.Type getStatus(Identity identity1, Identity identity2) throws RelationshipStorageException {
        Relationship relationship = this.get(identity1, identity2);
        return relationship == null ? null : relationship.getStatus();
    }

    public void registerListener(RelationshipListener listener) {
        this.lifeCycle.addListener(listener);
    }

    public void unregisterListener(RelationshipListener listener) {
        this.lifeCycle.removeListener(listener);
    }

    public void addListenerPlugin(RelationshipListenerPlugin plugin) {
        this.registerListener(plugin);
    }

    protected RelationshipStorage getStorage() {
        return this.storage;
    }

    protected void setStorage(RelationshipStorage storage) {
        this.storage = storage;
    }

    protected RelationshipLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    protected void setLifeCycle(RelationshipLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    protected List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.storage.getRelationships(identity, type, identities);
    }

    protected List<Relationship> getSender(Identity sender, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.storage.getSenderRelationships(sender, type, identities);
    }

    protected List<Relationship> getReceiver(Identity receiver, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.storage.getReceiverRelationships(receiver, type, identities);
    }

    @Override
    public Relationship create(Identity sender, Identity receiver) {
        return new Relationship(sender, receiver);
    }

    @Override
    public List<Identity> findRelationships(Identity ownerIdentity, Relationship.Type relationshipType) throws RelationshipStorageException {
        List<Relationship> allRelationships = this.getAll(ownerIdentity, relationshipType, null);
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (allRelationships == null || allRelationships.size() == 0) {
            return identities;
        }
        for (Relationship relationship : allRelationships) {
            identities.add(relationship.getPartner(ownerIdentity));
        }
        return identities;
    }

    @Override
    public List<Relationship> findRoute(Identity sender, Identity receiver) throws RelationshipStorageException {
        ArrayList<Relationship> route = new ArrayList<Relationship>();
        route.add(this.get(sender, receiver));
        return route;
    }

    @Override
    public Relationship.Type getConnectionStatus(Identity fromIdentity, Identity toIdentity) throws Exception {
        return this.getStatus(fromIdentity, toIdentity);
    }

    @Override
    public ListAccess<Identity> getConnections(Identity identity) {
        return new ConnectionListAccess(this.storage, identity, ConnectionListAccess.Type.CONNECTION);
    }

    @Override
    public List<Relationship> getContacts(Identity currIdentity, List<Identity> identities) throws RelationshipStorageException {
        return this.getAll(currIdentity, Relationship.Type.CONFIRMED, identities);
    }

    @Override
    public List<Relationship> getContacts(Identity identity) throws RelationshipStorageException {
        return this.getAll(identity, Relationship.Type.CONFIRMED, null);
    }

    @Override
    public List<Identity> getIdentities(Identity id) throws Exception {
        return Arrays.asList(this.getConnections(id).load(0, 200));
    }

    @Override
    public List<Relationship> getPendingRelationships(Identity identity) throws RelationshipStorageException {
        return this.getPending(identity);
    }

    @Override
    public List<Relationship> getPendingRelationships(Identity identity, boolean toConfirm) throws RelationshipStorageException {
        return this.getAll(identity, Relationship.Type.PENDING, null);
    }

    @Override
    public List<Relationship> getPendingRelationships(Identity currIdentity, List<Identity> identities, boolean toConfirm) throws RelationshipStorageException {
        return this.getAll(currIdentity, Relationship.Type.PENDING, identities);
    }

    @Override
    public Relationship getRelationship(Identity sender, Identity receiver) throws RelationshipStorageException {
        return this.get(sender, receiver);
    }

    @Override
    public Relationship getRelationshipById(String id) throws RelationshipStorageException {
        return this.get(id);
    }

    @Override
    public Relationship.Type getRelationshipStatus(Relationship rel, Identity id) {
        return rel.getStatus();
    }

    @Override
    public List<Relationship> getRelationshipsByIdentityId(String id) throws RelationshipStorageException {
        return this.getAll(this.getIdentityManager().getIdentity(id));
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    @Override
    public void saveRelationship(Relationship relationship) throws RelationshipStorageException {
        this.save(relationship);
    }

    @Override
    public List<Relationship> getAllRelationships(Identity identity) throws RelationshipStorageException {
        return this.getAll(identity);
    }

    @Override
    public void confirm(Identity invitedIdentity, Identity invitingIdentity) {
        Relationship relationship = this.get(invitedIdentity, invitingIdentity);
        if (relationship != null && relationship.getStatus() == Relationship.Type.PENDING) {
            relationship.setStatus(Relationship.Type.CONFIRMED);
            this.update(relationship);
            this.lifeCycle.relationshipConfirmed(this, relationship);
        }
    }

    @Override
    public void delete(Relationship existingRelationship) {
        this.storage.removeRelationship(existingRelationship);
        this.lifeCycle.relationshipRemoved(this, existingRelationship);
    }

    @Override
    public void deny(Identity invitedIdentity, Identity invitingIdentity) {
        Relationship relationship = this.get(invitedIdentity, invitingIdentity);
        if (relationship != null && relationship.getStatus() == Relationship.Type.PENDING) {
            this.delete(relationship);
            this.lifeCycle.relationshipDenied(this, relationship);
        }
    }

    @Override
    public ListAccess<Identity> getAllWithListAccess(Identity existingIdentity) {
        return new ConnectionListAccess(this.storage, existingIdentity, ConnectionListAccess.Type.ALL);
    }

    @Override
    public ListAccess<Identity> getIncomingWithListAccess(Identity existingIdentity) {
        return new ConnectionListAccess(this.storage, existingIdentity, ConnectionListAccess.Type.INCOMING);
    }

    @Override
    public ListAccess<Identity> getOutgoing(Identity existingIdentity) {
        return new ConnectionListAccess(this.storage, existingIdentity, ConnectionListAccess.Type.OUTGOING);
    }

    @Override
    public void ignore(Identity invitedIdentity, Identity invitingIdentity) {
        Relationship relationship = this.get(invitedIdentity, invitingIdentity);
        if (relationship != null) {
            this.delete(relationship);
            this.lifeCycle.relationshipIgnored(this, relationship);
        }
    }

    @Override
    public Relationship inviteToConnect(Identity invitingIdentity, Identity invitedIdentity) {
        Relationship relationship = this.get(invitingIdentity, invitedIdentity);
        if (relationship == null) {
            relationship = new Relationship(invitingIdentity, invitedIdentity);
            relationship.setStatus(Relationship.Type.PENDING);
            this.update(relationship);
            this.lifeCycle.relationshipRequested(this, relationship);
        }
        return relationship;
    }

    @Override
    public void update(Relationship existingRelationship) {
        String receiverId;
        String senderId = existingRelationship.getSender().getId();
        if (senderId.equals(receiverId = existingRelationship.getReceiver().getId())) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_SAVE_RELATIONSHIP, "the two identity are the same");
        }
        this.storage.saveRelationship(existingRelationship);
    }

    @Override
    public ListAccess<Identity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter) {
        return new ConnectionFilterListAccess(this.storage, existingIdentity, profileFilter, ConnectionFilterListAccess.Type.PROFILE_FILTER_CONNECTION);
    }

    @Override
    public ListAccess<Identity> getIncomingByFilter(Identity existingIdentity, ProfileFilter profileFilter) {
        return new ConnectionFilterListAccess(this.storage, existingIdentity, profileFilter, ConnectionFilterListAccess.Type.PROFILE_FILTER_INCOMMING);
    }

    @Override
    public ListAccess<Identity> getOutgoingByFilter(Identity existingIdentity, ProfileFilter profileFilter) {
        return new ConnectionFilterListAccess(this.storage, existingIdentity, profileFilter, ConnectionFilterListAccess.Type.PROFILE_FILTER_OUTGOING);
    }

    @Override
    public Map<Identity, Integer> getSuggestions(Identity identity, int maxConnections, int maxConnectionsToLoad, int maxSuggestions) {
        return this.storage.getSuggestions(identity, maxConnections, maxConnectionsToLoad, maxSuggestions);
    }

    @Override
    public Map<Identity, Integer> getSuggestions(Identity identity, int offset, int limit) {
        Map<Identity, Integer> result = this.storage.getSuggestions(identity, -1, -1, offset + limit);
        if (result != null && !result.isEmpty()) {
            Iterator<Map.Entry<Identity, Integer>> it;
            if (offset > 0) {
                result = new LinkedHashMap<Identity, Integer>(result);
                it = result.entrySet().iterator();
                for (int o = 0; it.hasNext() && o < offset; ++o) {
                    it.next();
                    it.remove();
                }
            }
            if (result.size() > limit) {
                result = new LinkedHashMap<Identity, Integer>(result);
                int i = 0;
                it = result.entrySet().iterator();
                while (it.hasNext()) {
                    it.next();
                    if (i >= limit) {
                        it.remove();
                    }
                    ++i;
                }
            }
        }
        return result;
    }
}

