/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.storage.cache.FutureExoCache;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ListSpacesData;
import org.exoplatform.social.core.storage.cache.model.data.SpaceData;
import org.exoplatform.social.core.storage.cache.model.data.SpaceSimpleData;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpacesKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceRefKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceType;
import org.exoplatform.social.core.storage.cache.selector.IdentityCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.ScopeCacheSelector;
import org.exoplatform.social.core.storage.impl.SpaceStorageImpl;

public class CachedSpaceStorage
implements SpaceStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedSpaceStorage.class);
    private final ExoCache<SpaceKey, SpaceData> exoSpaceCache;
    private final ExoCache<SpaceKey, SpaceSimpleData> exoSpaceSimpleCache;
    private final ExoCache<SpaceRefKey, SpaceKey> exoRefSpaceCache;
    private final ExoCache<SpaceFilterKey, IntegerData> exoSpacesCountCache;
    private final ExoCache<ListSpacesKey, ListSpacesData> exoSpacesCache;
    private final ExoCache<ListIdentitiesKey, ListIdentitiesData> exoIdentitiesCache;
    private final FutureExoCache<SpaceKey, SpaceData, ServiceContext<SpaceData>> spaceCache;
    private final FutureExoCache<SpaceKey, SpaceSimpleData, ServiceContext<SpaceSimpleData>> spaceSimpleCache;
    private final FutureExoCache<SpaceRefKey, SpaceKey, ServiceContext<SpaceKey>> spaceRefCache;
    private final FutureExoCache<SpaceFilterKey, IntegerData, ServiceContext<IntegerData>> spacesCountCache;
    private final FutureExoCache<ListSpacesKey, ListSpacesData, ServiceContext<ListSpacesData>> spacesCache;
    private final SpaceStorageImpl storage;
    private CachedActivityStorage cachedActivityStorage;
    private CachedIdentityStorage cachedIdentityStorage;

    private List<Space> buildSpaces(ListSpacesData data) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (SpaceKey k : data.getIds()) {
            Space s = this.getSpaceById(k.getId());
            spaces.add(s);
        }
        return spaces;
    }

    private List<Space> buildSimpleSpaces(ListSpacesData data) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (SpaceKey k : data.getIds()) {
            Space s = this.getSpaceSimpleById(k.getId());
            spaces.add(s);
        }
        return spaces;
    }

    public CachedActivityStorage getCachedActivityStorage() {
        if (this.cachedActivityStorage == null) {
            this.cachedActivityStorage = (CachedActivityStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedActivityStorage.class);
        }
        return this.cachedActivityStorage;
    }

    public CachedIdentityStorage getCachedIdentityStorage() {
        if (this.cachedIdentityStorage == null) {
            this.cachedIdentityStorage = (CachedIdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedIdentityStorage.class);
        }
        return this.cachedIdentityStorage;
    }

    private ListSpacesData buildIds(List<Space> spaces) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (Space s : spaces) {
            SpaceKey k = new SpaceKey(s.getId());
            this.exoSpaceCache.put((Serializable)k, (Object)new SpaceData(s));
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    private ListSpacesData buildSimpleIds(List<Space> spaces) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (Space s : spaces) {
            SpaceKey k = new SpaceKey(s.getId());
            this.exoSpaceSimpleCache.put((Serializable)k, (Object)new SpaceSimpleData(s));
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    public CachedSpaceStorage(SpaceStorageImpl storage, SocialStorageCacheService cacheService) {
        this.storage = storage;
        this.exoSpaceCache = cacheService.getSpaceCache();
        this.exoSpaceSimpleCache = cacheService.getSpaceSimpleCache();
        this.exoRefSpaceCache = cacheService.getSpaceRefCache();
        this.exoSpacesCountCache = cacheService.getSpacesCountCache();
        this.exoSpacesCache = cacheService.getSpacesCache();
        this.exoIdentitiesCache = cacheService.getIdentitiesCache();
        this.spaceCache = CacheType.SPACE.createFutureCache(this.exoSpaceCache);
        this.spaceSimpleCache = CacheType.SPACE_SIMPLE.createFutureCache(this.exoSpaceSimpleCache);
        this.spaceRefCache = CacheType.SPACE_REF.createFutureCache(this.exoRefSpaceCache);
        this.spacesCountCache = CacheType.SPACES_COUNT.createFutureCache(this.exoSpacesCountCache);
        this.spacesCache = CacheType.SPACES.createFutureCache(this.exoSpacesCache);
    }

    private void cleanRef(SpaceData removed) {
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(removed.getDisplayName()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, removed.getPrettyName()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, removed.getGroupId()));
        this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, null, removed.getUrl()));
    }

    void clearIdentityCache() {
        try {
            this.exoIdentitiesCache.select((CachedObjectSelector)new IdentityCacheSelector("space"));
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    void clearSpaceCache() {
        try {
            this.exoSpacesCache.select(new ScopeCacheSelector());
            this.exoSpacesCountCache.select(new ScopeCacheSelector());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public Space getSpaceByDisplayName(final String spaceDisplayName) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(spaceDisplayName);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get(new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.this.storage.getSpaceByDisplayName(spaceDisplayName);
                if (space != null) {
                    SpaceKey key = new SpaceKey(space.getId());
                    CachedSpaceStorage.this.exoSpaceCache.put((Serializable)key, (Object)new SpaceData(space));
                    return key;
                }
                return null;
            }
        }, refKey);
        if (key != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public void saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        this.storage.saveSpace(space, isNew);
        this.exoSpaceSimpleCache.remove((Serializable)new SpaceKey(space.getId()));
        SpaceData removed = (SpaceData)this.exoSpaceCache.remove((Serializable)new SpaceKey(space.getId()));
        this.clearSpaceCache();
        this.clearIdentityCache();
        if (removed != null) {
            this.cleanRef(removed);
        }
    }

    @Override
    public void renameSpace(Space space, String newDisplayName) throws SpaceStorageException {
        this.renameSpace(null, space, newDisplayName);
    }

    @Override
    public void renameSpace(String remoteId, Space space, String newDisplayName) throws SpaceStorageException {
        String oldDisplayName = space.getDisplayName();
        String oldUrl = SpaceUtils.cleanString(oldDisplayName);
        String oldPrettyName = space.getPrettyName();
        this.storage.renameSpace(remoteId, space, newDisplayName);
        this.cachedIdentityStorage = this.getCachedIdentityStorage();
        Identity identitySpace = this.cachedIdentityStorage.findIdentity("space", space.getPrettyName());
        if (identitySpace == null) {
            identitySpace = this.cachedIdentityStorage.findIdentity("space", oldPrettyName);
        }
        if (identitySpace != null) {
            this.cachedIdentityStorage.clearIdentityCached(identitySpace, oldPrettyName);
        }
        this.cachedActivityStorage = this.getCachedActivityStorage();
        this.cachedActivityStorage.clearOwnerStreamCache(oldPrettyName);
        SpaceData removed = (SpaceData)this.exoSpaceCache.remove((Serializable)new SpaceKey(space.getId()));
        this.clearSpaceCache();
        this.clearIdentityCache();
        if (removed != null) {
            this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(oldDisplayName));
            this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, oldPrettyName));
            this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, removed.getGroupId()));
            this.exoRefSpaceCache.remove((Serializable)new SpaceRefKey(null, null, null, oldUrl));
        }
    }

    @Override
    public void deleteSpace(String id) throws SpaceStorageException {
        Space space = this.storage.getSpaceById(id);
        this.storage.deleteSpace(id);
        SpaceData removed = (SpaceData)this.exoSpaceCache.remove((Serializable)new SpaceKey(id));
        this.clearSpaceCache();
        if (removed != null) {
            this.cleanRef(removed);
        }
        this.getCachedActivityStorage().clearCache();
    }

    @Override
    public int getMemberSpacesCount(final String userId) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, null);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getMemberSpacesCount(userId));
            }
        }, key)).build();
    }

    @Override
    public int getMemberSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MEMBER);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getMemberSpacesByFilterCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getMemberSpaces(String userId) throws SpaceStorageException {
        return this.storage.getMemberSpaces(userId);
    }

    @Override
    public List<Space> getMemberSpaces(final String userId, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.MEMBER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getMemberSpaces(userId, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getMemberSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MEMBER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getMemberSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getPendingSpacesCount(final String userId) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.PENDING);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getPendingSpacesCount(userId));
            }
        }, key)).build();
    }

    @Override
    public int getPendingSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PENDING);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getPendingSpacesByFilterCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getPendingSpaces(String userId) throws SpaceStorageException {
        return this.storage.getPendingSpaces(userId);
    }

    @Override
    public List<Space> getPendingSpaces(final String userId, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.PENDING);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getPendingSpaces(userId, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getPendingSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PENDING);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getPendingSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getInvitedSpacesCount(final String userId) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.INVITED);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getInvitedSpacesCount(userId));
            }
        }, key)).build();
    }

    @Override
    public int getInvitedSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.INVITED);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getInvitedSpacesByFilterCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getInvitedSpaces(String userId) throws SpaceStorageException {
        return this.storage.getInvitedSpaces(userId);
    }

    @Override
    public List<Space> getInvitedSpaces(final String userId, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.INVITED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getInvitedSpaces(userId, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getInvitedSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.INVITED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getInvitedSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getPublicSpacesCount(final String userId) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.PUBLIC);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getPublicSpacesCount(userId));
            }
        }, key)).build();
    }

    @Override
    public int getPublicSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PUBLIC);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getPublicSpacesByFilterCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getPublicSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PUBLIC);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getPublicSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getPublicSpaces(String userId) throws SpaceStorageException {
        return this.storage.getPublicSpaces(userId);
    }

    @Override
    public List<Space> getPublicSpaces(final String userId, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.PUBLIC);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getPublicSpaces(userId, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getAccessibleSpacesCount(final String userId) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.ACCESSIBLE);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getAccessibleSpacesCount(userId));
            }
        }, key)).build();
    }

    @Override
    public int getAccessibleSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.ACCESSIBLE);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getAccessibleSpacesByFilterCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public int getLastAccessedSpaceCount(final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(spaceFilter.getRemoteId(), spaceFilter, SpaceType.LATEST_ACCESSED);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getLastAccessedSpaceCount(spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public int getVisibleSpacesCount(final String userId, final SpaceFilter spaceFilter) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.VISIBLE);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getVisibleSpacesCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public int getUnifiedSearchSpacesCount(final String userId, final SpaceFilter spaceFilter) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.UNIFIED_SEARCH);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getUnifiedSearchSpacesCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getVisibleSpaces(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.VISIBLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getVisibleSpaces(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getUnifiedSearchSpaces(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.UNIFIED_SEARCH);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getUnifiedSearchSpaces(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getAccessibleSpaces(String userId) throws SpaceStorageException {
        return this.storage.getAccessibleSpaces(userId);
    }

    @Override
    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.storage.getVisibleSpaces(userId, spaceFilter);
    }

    @Override
    public List<Space> getAccessibleSpaces(final String userId, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.ACCESSIBLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getAccessibleSpaces(userId, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getAccessibleSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.ACCESSIBLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getAccessibleSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getEditableSpacesCount(final String userId) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.EDITABLE);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getEditableSpacesCount(userId));
            }
        }, key)).build();
    }

    @Override
    public int getEditableSpacesByFilterCount(final String userId, final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.EDITABLE);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getEditableSpacesByFilterCount(userId, spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getEditableSpaces(String userId) throws SpaceStorageException {
        return this.storage.getEditableSpaces(userId);
    }

    @Override
    public List<Space> getEditableSpaces(final String userId, final long offset, final long limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.EDITABLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getEditableSpaces(userId, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getEditableSpacesByFilter(final String userId, final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.EDITABLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getEditableSpacesByFilter(userId, spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getAllSpacesCount() throws SpaceStorageException {
        return this.storage.getAllSpacesCount();
    }

    @Override
    public List<Space> getAllSpaces() throws SpaceStorageException {
        return this.storage.getAllSpaces();
    }

    @Override
    public int getAllSpacesByFilterCount(final SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(null, spaceFilter, null);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getAllSpacesByFilterCount(spaceFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getSpaces(final long offset, final long limit) throws SpaceStorageException {
        ListSpacesKey listKey = new ListSpacesKey(null, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getSpaces(offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getSpacesByFilter(final SpaceFilter spaceFilter, final long offset, final long limit) {
        SpaceFilterKey key = new SpaceFilterKey(null, spaceFilter, null);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getSpacesByFilter(spaceFilter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public Space getSpaceById(final String id) throws SpaceStorageException {
        SpaceKey key = new SpaceKey(id);
        SpaceData data = (SpaceData)this.spaceCache.get(new ServiceContext<SpaceData>(){

            @Override
            public SpaceData execute() {
                Space space = CachedSpaceStorage.this.storage.getSpaceById(id);
                if (space != null) {
                    return new SpaceData(space);
                }
                return null;
            }
        }, key);
        if (data != null) {
            return data.build();
        }
        return null;
    }

    @Override
    public Space getSpaceSimpleById(final String id) throws SpaceStorageException {
        SpaceKey key = new SpaceKey(id);
        SpaceData data = (SpaceData)this.exoSpaceCache.get((Serializable)key);
        if (data != null) {
            Space s = data.build();
            if (this.exoSpaceSimpleCache.get((Serializable)key) == null) {
                this.exoSpaceSimpleCache.put((Serializable)key, (Object)new SpaceSimpleData(s));
            }
            return s;
        }
        SpaceSimpleData simpleData = (SpaceSimpleData)this.spaceSimpleCache.get(new ServiceContext<SpaceSimpleData>(){

            @Override
            public SpaceSimpleData execute() {
                Space space = CachedSpaceStorage.this.storage.getSpaceSimpleById(id);
                if (space != null) {
                    return new SpaceSimpleData(space);
                }
                return null;
            }
        }, key);
        if (simpleData != null) {
            return simpleData.build();
        }
        return null;
    }

    @Override
    public Space getSpaceByPrettyName(final String spacePrettyName) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, spacePrettyName);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get(new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.this.storage.getSpaceByPrettyName(spacePrettyName);
                if (space != null) {
                    SpaceKey key = new SpaceKey(space.getId());
                    CachedSpaceStorage.this.exoSpaceCache.put((Serializable)key, (Object)new SpaceData(space));
                    return key;
                }
                return null;
            }
        }, refKey);
        if (key != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public Space getSpaceByGroupId(final String groupId) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, null, groupId);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get(new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.this.storage.getSpaceByGroupId(groupId);
                if (space != null) {
                    SpaceKey key = new SpaceKey(space.getId());
                    CachedSpaceStorage.this.exoSpaceCache.put((Serializable)key, (Object)new SpaceData(space));
                    return key;
                }
                return null;
            }
        }, refKey);
        if (key != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public Space getSpaceByUrl(final String url) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, null, null, url);
        SpaceKey key = (SpaceKey)this.spaceRefCache.get(new ServiceContext<SpaceKey>(){

            @Override
            public SpaceKey execute() {
                Space space = CachedSpaceStorage.this.storage.getSpaceByUrl(url);
                if (space != null) {
                    SpaceKey key = new SpaceKey(space.getId());
                    CachedSpaceStorage.this.exoSpaceCache.put((Serializable)key, (Object)new SpaceData(space));
                    return key;
                }
                return null;
            }
        }, refKey);
        if (key != null) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceStorageException {
        this.storage.updateSpaceAccessed(remoteId, space);
        this.clearSpaceCache();
    }

    @Override
    public List<Space> getLastAccessedSpace(final SpaceFilter filter, final int offset, final int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(filter.getRemoteId(), filter, SpaceType.MEMBER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getLastAccessedSpace(filter, offset, limit);
                return CachedSpaceStorage.this.buildSimpleIds(got);
            }
        }, listKey);
        return this.buildSimpleSpaces(keys);
    }

    @Override
    public List<Space> getLastSpaces(final int limit) {
        SpaceFilter filter = new SpaceFilter(null, null);
        filter.setSorting(new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC));
        SpaceFilterKey key = new SpaceFilterKey(null, filter, null);
        ListSpacesKey listKey = new ListSpacesKey(key, 0L, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getLastSpaces(limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSimpleSpaces(keys);
    }

    @Override
    public int getNumberOfMemberPublicSpaces(final String userId) {
        SpaceFilterKey key = new SpaceFilterKey(userId, null, SpaceType.PUBLIC);
        return (Integer)((IntegerData)this.spacesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedSpaceStorage.this.storage.getNumberOfMemberPublicSpaces(userId));
            }
        }, key)).build();
    }

    @Override
    public List<Space> getVisitedSpaces(final SpaceFilter filter, final int offset, final int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(filter.getRemoteId(), filter, SpaceType.VISITED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesCache.get(new ServiceContext<ListSpacesData>(){

            @Override
            public ListSpacesData execute() {
                List<Space> got = CachedSpaceStorage.this.storage.getVisitedSpaces(filter, offset, limit);
                return CachedSpaceStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildSpaces(keys);
    }
}

