/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.parser.ParserBase;
import com.google.caja.util.TestUtil;
import junit.framework.TestCase;

public class ParserBaseTest
extends TestCase {
    public final void testIsJavascriptIdentifier() {
        for (String s : new String[]{"$", "_", "$$", "_foo_bar", "fooBar", "h3", "i", "___", "__proto__", "FOO_BAR_BAZ_", "i18n", "ev\\u0061l"}) {
            ParserBaseTest.assertTrue((String)s, (boolean)ParserBase.isJavascriptIdentifier(s));
        }
        for (String s : new String[]{"\u0101\u0107\u0115", "\\u0101\\u0107\\u0115"}) {
            ParserBaseTest.assertEquals((String)s, (boolean)true, (TestUtil.isJava15() || ParserBase.isJavascriptIdentifier(s) ? 1 : 0) != 0);
        }
        for (String s : new String[]{"", "3$", "1", "\u0000", "", "a-b", "a.b", "3_", "a=b", "(a)", "'a'", "\\a", "\\u012", "\\u", "\\u0000", "ev`l"}) {
            ParserBaseTest.assertFalse((String)s, (boolean)ParserBase.isJavascriptIdentifier(s));
        }
    }

    public final void testDecodeIdentifier() {
        ParserBaseTest.assertEquals((String)"eval", (String)ParserBase.decodeIdentifier("eval"));
        ParserBaseTest.assertEquals((String)"eval", (String)ParserBase.decodeIdentifier("ev\\u0061l"));
    }
}

