/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.pdfviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import org.artofsolving.jodconverter.office.OfficeException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.icepdf.core.pobjects.Document;

public class PDFViewerService {
    private static final int MAX_NAME_LENGTH = 150;
    private static final Log LOG = ExoLogger.getLogger((String)PDFViewerService.class.getName());
    private JodConverterService jodConverter_;
    private ExoCache<Serializable, Object> pdfCache;
    private static final long MAX_FILE_SIZE = 0x500000L;

    public PDFViewerService(RepositoryService repositoryService, CacheService caService, JodConverterService jodConverter) throws Exception {
        this.jodConverter_ = jodConverter;
        this.pdfCache = caService.getCacheInstance(PDFViewerService.class.getName());
    }

    public ExoCache<Serializable, Object> getCache() {
        return this.pdfCache;
    }

    public Document initDocument(Node currentNode, String repoName) throws Exception {
        return this.buildDocumentImage(this.getPDFDocumentFile(currentNode, repoName), currentNode.getName());
    }

    public Document buildDocumentImage(File input, String name) {
        Document document = new Document();
        Logger.getLogger(Document.class.toString()).setLevel(Level.OFF);
        if (input == null) {
            return null;
        }
        try {
            name = this.reduceFileNameSize(name);
            FileInputStream fis = new FileInputStream(input);
            document.setInputStream((InputStream)new BufferedInputStream(fis), name);
            return document;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to build Document image", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public File getPDFDocumentFile(Node currentNode, String repoName) throws Exception {
        wsName = currentNode.getSession().getWorkspace().getName();
        uuid = currentNode.getUUID();
        bd = new StringBuilder();
        bd1 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        bd1.append((CharSequence)bd).append("/jcr:lastModified");
        path = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        lastModifiedTime = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.toString()));
        content = null;
        name = currentNode.getName().replaceAll(":", "_");
        contentNode = currentNode.getNode("jcr:content");
        lastModified = Utils.getJcrContentLastModified(currentNode);
        if (path == null || !(content = new File(path)).exists() || !lastModified.equals(lastModifiedTime)) {
            mimeType = contentNode.getProperty("jcr:mimeType").getString();
            input = new BufferedInputStream(contentNode.getProperty("jcr:data").getStream());
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            name = this.reduceFileNameSize(name);
            content = File.createTempFile(name + "_tmp", ".pdf");
            extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
            if ("pdf".equals(extension)) {
                this.read(input, new BufferedOutputStream(new FileOutputStream(content)));
            } else {
                in = File.createTempFile(name + "_tmp", null);
                this.read(input, new BufferedOutputStream(new FileOutputStream(in)));
                fileSize = in.length();
                PDFViewerService.LOG.info((Object)("File size: " + fileSize + " B. Size limit for preview: " + 5L + " MB"));
                if (fileSize < 0x500000L) {
                    try {
                        success = this.jodConverter_.convert(in, content, "pdf");
                        if (success) ** GOTO lbl55
                        content.delete();
                        content = null;
                    }
                    catch (OfficeException connection) {
                        content.delete();
                        content = null;
                        if (!PDFViewerService.LOG.isErrorEnabled()) ** GOTO lbl55
                        PDFViewerService.LOG.error((Object)"Exception when using Office Service", (Throwable)connection);
                    }
                    finally {
                        in.delete();
                    }
                } else {
                    PDFViewerService.LOG.info((Object)"File is too big for preview.");
                    content.delete();
                    content = null;
                    in.delete();
                }
            }
lbl55:
            // 6 sources

            if (content != null && content.exists() && contentNode.hasProperty("jcr:lastModified")) {
                this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)content.getPath());
                this.pdfCache.put((Serializable)new ObjectKey(bd1.toString()), (Object)lastModified);
            }
        }
        return content;
    }

    private String reduceFileNameSize(String name) {
        return name != null && name.length() > 150 ? name.substring(0, 150) : name;
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }
}

