/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/space/UIManageInvitationSpaces.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={IgnoreActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMoreSpaceActionListener.class})})
public class UIManageInvitationSpaces
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIManageInvitationSpaces.class);
    private static final String SPACE_DELETED_INFO = "UIManageInvitationSpaces.msg.DeletedInfo";
    private static final String INVITATION_REVOKED_INFO = "UIManageInvitationSpaces.msg.RevokedInfo";
    private static final String INCOMING_STATUS = "incoming";
    private static final String SEARCH_ALL = "All";
    private static final String SPACE_SEARCH = "SpaceSearch";
    public static final Integer LEADER = 1;
    public static final Integer MEMBER = 2;
    private final Integer SPACES_PER_PAGE = 20;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    private SpaceService spaceService = null;
    private String userId = null;
    private boolean loadAtEnd = false;
    private boolean hasUpdatedSpace = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private String spaceNameSearch;
    private List<Space> invitedSpacesList;
    private ListAccess<Space> invitedSpacesListAccess;
    private int invitedSpacesNum;
    private String selectedChar = null;

    public UIManageInvitationSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(INCOMING_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.init();
    }

    public void init() {
        try {
            this.setHasUpdatedSpace(false);
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = this.SPACES_PER_PAGE;
            this.invitedSpacesList = new ArrayList<Space>();
            this.setInvitedSpacesList(this.loadInvitedSpaces(this.currentLoadIndex, this.loadingCapacity));
            this.setSelectedChar(SEARCH_ALL);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public boolean isHasUpdatedSpace() {
        return this.hasUpdatedSpace;
    }

    public void setHasUpdatedSpace(boolean hasUpdatedSpace) {
        this.hasUpdatedSpace = hasUpdatedSpace;
    }

    public List<Space> getInvitedSpacesList() throws Exception {
        if (this.isHasUpdatedSpace()) {
            this.setHasUpdatedSpace(false);
            this.setInvitedSpacesList(this.loadInvitedSpaces(0, this.invitedSpacesList.size()));
        }
        this.setEnableLoadNext(this.invitedSpacesList.size() >= this.SPACES_PER_PAGE && this.invitedSpacesList.size() < this.getInvitedSpacesNum());
        return this.invitedSpacesList;
    }

    public void setInvitedSpacesList(List<Space> invitedSpacesList) {
        this.invitedSpacesList = invitedSpacesList;
    }

    public int getInvitedSpacesNum() {
        return this.invitedSpacesNum;
    }

    public void setInvitedSpacesNum(int invitedSpacesNum) {
        this.invitedSpacesNum = invitedSpacesNum;
    }

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public ListAccess<Space> getInvitedSpacesListAccess() {
        return this.invitedSpacesListAccess;
    }

    public void setInvitedSpacesListAccess(ListAccess<Space> invitedSpacesListAccess) {
        this.invitedSpacesListAccess = invitedSpacesListAccess;
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        if (this.currentLoadIndex <= this.getInvitedSpacesNum()) {
            this.invitedSpacesList.addAll(new ArrayList<Object>(Arrays.asList(this.getInvitedSpacesListAccess().load(this.currentLoadIndex, this.loadingCapacity))));
        }
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setInvitedSpacesList(this.loadInvitedSpaces(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Space> loadInvitedSpaces(int index, int length) throws Exception {
        String charSearch = this.getSelectedChar();
        String searchCondition = this.uiSpaceSearch.getSpaceNameSearch();
        if (SEARCH_ALL.equals(charSearch) || charSearch == null && searchCondition == null) {
            this.setInvitedSpacesListAccess((ListAccess<Space>)this.getSpaceService().getInvitedSpacesWithListAccess(this.getUserId()));
        } else if (searchCondition != null) {
            this.setInvitedSpacesListAccess((ListAccess<Space>)this.getSpaceService().getInvitedSpacesByFilter(this.getUserId(), new SpaceFilter(searchCondition)));
        } else if (charSearch != null) {
            this.setInvitedSpacesListAccess((ListAccess<Space>)this.getSpaceService().getInvitedSpacesByFilter(this.getUserId(), new SpaceFilter(charSearch.charAt(0))));
        }
        this.setInvitedSpacesNum(this.getInvitedSpacesListAccess().getSize());
        this.uiSpaceSearch.setSpaceNum(this.getInvitedSpacesNum());
        Space[] spaces = (Space[])this.getInvitedSpacesListAccess().load(index, length);
        return new ArrayList<Space>(Arrays.asList(spaces));
    }

    public int getRole(String spaceId) throws SpaceException {
        SpaceService spaceService = Utils.getSpaceService();
        if (spaceService.hasSettingPermission(spaceService.getSpaceById(spaceId), Utils.getViewerRemoteId())) {
            return LEADER;
        }
        return MEMBER;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public static class IgnoreActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiManageInvitationSpaces = (UIManageInvitationSpaces)((Object)event.getSource());
            SpaceService spaceService = Utils.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = Utils.getViewerRemoteId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageInvitationSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvitedUser(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            uiManageInvitationSpaces.setHasUpdatedSpace(true);
            spaceService.removeInvitedUser(space, userId);
        }
    }

    public static class AcceptActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiManageInvitationSpaces = (UIManageInvitationSpaces)((Object)event.getSource());
            SpaceService spaceService = Utils.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = Utils.getViewerRemoteId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageInvitationSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvitedUser(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            spaceService.addMember(space, userId);
            uiManageInvitationSpaces.setHasUpdatedSpace(true);
            SpaceUtils.updateWorkingWorkSpace();
            JavascriptManager jsManager = ctx.getJavascriptManager();
            jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(space) + "' } catch(e) {" + "window.location.href('" + Utils.getSpaceHomeURL(space) + "') }"));
        }
    }

    public static class SearchActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiManageInvitedSpaces = (UIManageInvitationSpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            String charSearch = ctx.getRequestParameter("objectId");
            if (charSearch == null) {
                uiManageInvitedSpaces.setSelectedChar(null);
            } else {
                ResourceBundle resApp = ctx.getApplicationResourceBundle();
                String defaultSpaceNameAndDesc = resApp.getString(uiManageInvitedSpaces.getId() + ".label.DefaultSpaceNameAndDesc");
                uiManageInvitedSpaces.uiSpaceSearch.getUIStringInput(UIManageInvitationSpaces.SPACE_SEARCH).setValue((Object)defaultSpaceNameAndDesc);
                uiManageInvitedSpaces.setSelectedChar(charSearch);
                uiManageInvitedSpaces.uiSpaceSearch.setSpaceNameSearch(null);
            }
            uiManageInvitedSpaces.loadSearch();
            uiManageInvitedSpaces.setLoadAtEnd(false);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiManageInvitedSpaces);
        }
    }

    public static class LoadMoreSpaceActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiManageInvitedSpaces = (UIManageInvitationSpaces)((Object)event.getSource());
            uiManageInvitedSpaces.loadNext();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageInvitedSpaces);
        }
    }
}

