/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UIApplicationCategorySelector;
import org.exoplatform.social.webui.UIApplicationListSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceApplicationInstaller.gtmpl", events={@EventConfig(listeners={SelectActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={InstallApplicationActionListener.class}, phase=Event.Phase.DECODE)})
public class UISpaceApplicationInstaller
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger(UISpaceApplicationInstaller.class);
    private Map<ApplicationCategory, List<Application>> appStore;
    private String spaceId;
    private List<ApplicationCategory> applicationCategoryList;
    private UIApplicationCategorySelector uiApplicationCategorySelector = (UIApplicationCategorySelector)this.addChild(UIApplicationCategorySelector.class, null, null);
    private UIApplicationListSelector uiApplicationListSelector = (UIApplicationListSelector)this.addChild(UIApplicationListSelector.class, null, null);

    public void activate() {
    }

    public void deActivate() {
    }

    public final void setSpace(Space newSpace) throws Exception {
        this.spaceId = newSpace.getId();
        this.initAppStore();
        this.initUICategoryAndList();
    }

    private void installApplication() {
        String appId = this.uiApplicationListSelector.getSelectedApplication().getApplicationName();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        try {
            spaceService.installApplication(this.spaceId, appId);
            spaceService.activateApplication(this.spaceId, appId);
        }
        catch (SpaceException e) {
            LOG.warn((Object)("Failed to install application: " + appId), (Throwable)e);
        }
    }

    private void initAppStore() throws Exception {
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = spaceService.getSpaceById(this.spaceId);
        this.appStore = SpaceUtils.getAppStore((Space)space);
        this.applicationCategoryList = new ArrayList<ApplicationCategory>(this.appStore.keySet());
    }

    private void initUICategoryAndList() {
        this.uiApplicationCategorySelector.setApplicationCategoryList(this.applicationCategoryList);
        ApplicationCategory selectedApplicationCategory = this.applicationCategoryList.get(0);
        List<Application> applicationList = this.appStore.get(selectedApplicationCategory);
        this.uiApplicationListSelector.setApplicationList(applicationList);
    }

    private void setApplicationList() {
        ApplicationCategory selectedApplicationCategory = this.uiApplicationCategorySelector.getSelectedApplicationCategory();
        List<Application> applicationList = this.appStore.get(selectedApplicationCategory);
        this.uiApplicationListSelector.setApplicationList(applicationList);
    }

    public static class InstallApplicationActionListener
    extends EventListener<UISpaceApplicationInstaller> {
        public void execute(Event<UISpaceApplicationInstaller> event) throws Exception {
            UISpaceApplicationInstaller uiSpaceApplicationInstaller = (UISpaceApplicationInstaller)((Object)event.getSource());
            uiSpaceApplicationInstaller.installApplication();
            if (uiSpaceApplicationInstaller.getParent() != null && uiSpaceApplicationInstaller.getParent().getParent() != null && uiSpaceApplicationInstaller.getParent().getParent().getParent() != null) {
                Event installApplicationEvent = uiSpaceApplicationInstaller.getParent().getParent().getParent().createEvent("InstallApplication", Event.Phase.DECODE, event.getRequestContext());
                if (installApplicationEvent == null) {
                    LOG.warn((Object)"Failed to broadcast InstallApplicationActionListener.");
                    return;
                }
                installApplicationEvent.broadcast();
            }
        }
    }

    public static class SelectActionListener
    extends EventListener<UISpaceApplicationInstaller> {
        public void execute(Event<UISpaceApplicationInstaller> event) throws Exception {
            UISpaceApplicationInstaller uiSpaceApplicationInstaller = (UISpaceApplicationInstaller)((Object)event.getSource());
            uiSpaceApplicationInstaller.setApplicationList();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceApplicationInstaller);
        }
    }
}

