/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import org.exoplatform.services.mail.Message;
import org.json.JSONObject;

public class MessageInfo {
    private String id;
    private String from;
    private String to;
    private String body = "";
    private String subject = "";
    private String footer;
    private String pluginId = "digest";
    private long createdTime;

    public MessageInfo setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public MessageInfo pluginId(String pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public MessageInfo from(String from) {
        this.from = from;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public MessageInfo to(String to) {
        this.to = to;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public MessageInfo body(String body) {
        this.body = body;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public MessageInfo subject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getFooter() {
        return this.footer;
    }

    public MessageInfo footer(String footer) {
        this.footer = footer;
        return this;
    }

    public MessageInfo end() {
        return this;
    }

    public Message makeEmailNotification() {
        Message message = new Message();
        message.setMimeType("text/html");
        message.setFrom(this.from);
        message.setTo(this.to);
        message.setSubject(this.subject);
        message.setBody(this.body + (this.footer != null && this.footer.length() > 0 ? this.footer : ""));
        return message;
    }

    public String makeNotification() {
        return this.toString();
    }

    public String toJSON() {
        return new JSONObject((Object)this).toString();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String body = this.body + (this.footer != null && this.footer.length() > 0 ? this.footer : "");
        builder.append("{ ").append("subject: '").append(this.subject.replaceAll("'", "&#39;")).append("', ").append("from: '").append(this.from).append("', ").append("to: '").append(this.to).append("', ").append("body: '").append(body.replaceAll("'", "&#39;")).append("' ").append("}");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageInfo && this.getId().equals(((MessageInfo)obj).getId())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

