/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.notification.plugin;

import java.net.URLEncoder;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;

public class FileActivityChildPlugin
extends AbstractNotificationChildPlugin {
    private static final Log LOG = ExoLogger.getLogger(FileActivityChildPlugin.class);
    public static final ArgumentLiteral<String> ACTIVITY_ID = new ArgumentLiteral(String.class, "activityId");
    public static final String PRIVATE_FOLDER_PATH = "/Private/";
    public static final String ACTIVITY_URL = "view_full_activity";
    public static final String ID = "files:spaces";
    public static final String MESSAGE = "MESSAGE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCLINK = "DOCLINK";
    public static final String NODE_UUID = "id";
    public static final String AUTHOR = "author";
    public static final String MIME_TYPE = "mimeType";
    public static final String DOCUMENT_TITLE = "docTitle";
    public static final String CONTENT_NAME = "contentName";
    public static final String DOCUMENT_SUMMARY = "docSummary";
    public static final String EXO_RESOURCES_URI = "/eXoResources/skin/images/Icons/TypeIcons/EmailNotificationIcons/";
    public static final String DOCNAME = "DOCNAME";
    public static final String ICON_FILE_EXTENSION = ".png";
    private String mimeType;
    private String nodeUUID;
    private Node contentNode;
    private NodeLocation nodeLocation;
    private String documentTitle;
    private ExoSocialActivity activity;
    private String repository;
    private String workspace;
    private String baseURI;
    private String docName;

    public FileActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        try {
            ActivityManager activityM = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(ID, language);
            String activityId = notification.getValueOwnerParameter(ACTIVITY_ID.getKey());
            this.activity = activityM.getActivity(activityId);
            if (this.activity.isComment()) {
                this.activity = activityM.getParentActivity(this.activity);
            }
            Map templateParams = this.activity.getTemplateParams();
            this.getAndSetFileInfo(templateParams);
            Node currentNode = this.getContentNode();
            String message = templateParams.get(MESSAGE) != null ? NotificationUtils.processLinkTitle((String)((String)templateParams.get(MESSAGE))) : "";
            templateContext.put((Object)"ACTIVITY_URL", (Object)LinkProviderUtils.getRedirectUrl((String)ACTIVITY_URL, (String)this.activity.getId()));
            templateContext.put((Object)"ACTIVITY_TITLE", (Object)message);
            templateContext.put((Object)"DOCUMENT_TITLE", (Object)this.documentTitle);
            templateContext.put((Object)"SUMMARY", (Object)org.exoplatform.wcm.ext.component.activity.listener.Utils.getSummary(currentNode));
            templateContext.put((Object)"SIZE", (Object)this.getSize(currentNode));
            templateContext.put((Object)"VERSION", (Object)this.getVersion(currentNode));
            templateContext.put((Object)"IS_VIDEO", (Object)this.mimeType.startsWith("video"));
            String thumbnailUrl = null;
            String docLink = (String)templateParams.get(DOCLINK);
            String author = (String)templateParams.get(AUTHOR);
            String receiver = notification.getTo();
            if (docLink != null && docLink.contains(author + PRIVATE_FOLDER_PATH) && author != receiver) {
                templateContext.put((Object)"DEFAULT_THUMBNAIL_URL", this.getDefaultThumbnail());
            } else {
                thumbnailUrl = this.getThumbnailUrl(currentNode);
                if (thumbnailUrl == null) {
                    templateContext.put((Object)"DEFAULT_THUMBNAIL_URL", this.getDefaultThumbnail());
                }
            }
            templateContext.put((Object)"THUMBNAIL_URL", (Object)thumbnailUrl);
            String content = TemplateUtils.processGroovy((TemplateContext)templateContext);
            return content;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed at makeContent().", (Throwable)e);
            return this.activity != null ? this.activity.getTitle() : "";
        }
    }

    public String getActivityParamValue(String key) {
        Map params = this.activity.getTemplateParams();
        if (params != null) {
            return params.get(key) != null ? (String)params.get(key) : "";
        }
        return "";
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }

    private void getAndSetFileInfo(Map<String, String> templateParams) {
        this.repository = templateParams.get(REPOSITORY);
        this.workspace = templateParams.get(WORKSPACE);
        this.nodeUUID = templateParams.get(NODE_UUID);
        this.mimeType = templateParams.get(MIME_TYPE);
        this.docName = templateParams.get(DOCNAME);
        String documentTitle = templateParams.get(DOCUMENT_TITLE);
        this.documentTitle = documentTitle != null ? documentTitle : templateParams.get(CONTENT_NAME);
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageRepo = null;
        try {
            manageRepo = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = CommonsUtils.getSystemSessionProvider();
            for (String ws : manageRepo.getWorkspaceNames()) {
                try {
                    this.contentNode = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(this.nodeUUID);
                    break;
                }
                catch (RepositoryException e) {
                }
            }
        }
        catch (RepositoryException re) {
            LOG.error((Object)"Can not get the repository. ", (Throwable)re);
        }
        this.nodeLocation = NodeLocation.getNodeLocationByNode((Node)this.contentNode);
        this.baseURI = CommonsUtils.getCurrentDomain();
    }

    private Object getDefaultThumbnail() {
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)this.docName, (String)this.mimeType, (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64);
        if (cssClass.indexOf("FileDefault") > 0) {
            return this.baseURI + EXO_RESOURCES_URI + "uiIcon64x64Templatent_file.png";
        }
        return this.baseURI + EXO_RESOURCES_URI + cssClass.split(" ")[0] + ICON_FILE_EXTENSION;
    }

    private String getThumbnailUrl(Node currentNode) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
            String portalName = containerInfo.getContainerName();
            String restContextName = org.exoplatform.ecm.webui.utils.Utils.getRestContextName((String)portalName);
            String preferenceWS = currentNode.getSession().getWorkspace().getName();
            String encodedPath = URLEncoder.encode(currentNode.getPath(), "utf-8");
            encodedPath = encodedPath.replaceAll("%2F", "/");
            if (this.mimeType.startsWith("image")) {
                int imageWidth = this.getImageWidth(currentNode);
                int imageHeight = this.getImageHeight(currentNode);
                if (imageHeight > imageWidth && imageHeight > 300) {
                    imageWidth = 300 * imageWidth / imageHeight;
                    imageHeight = 300;
                } else if (imageWidth > imageHeight && imageWidth > 300) {
                    imageHeight = 300 * imageHeight / imageWidth;
                    imageWidth = 300;
                } else if (imageWidth == imageHeight && imageHeight > 300) {
                    imageWidth = 300;
                    imageHeight = 300;
                }
                return this.baseURI + "/" + portalName + "/" + restContextName + "/thumbnailImage/custom/" + imageWidth + "x" + imageHeight + "/" + this.repository + "/" + preferenceWS + encodedPath;
            }
            if (this.mimeType.indexOf("icon") >= 0) {
                return this.getWebdavURL();
            }
            if (Utils.isSupportThumbnailView((String)this.mimeType)) {
                return this.baseURI + "/" + portalName + "/" + restContextName + "/thumbnailImage/big/" + this.repository + "/" + preferenceWS + encodedPath;
            }
            return null;
        }
        catch (Exception e) {
            LOG.debug((Object)"Cannot get thumbnail url");
            return "";
        }
    }

    private Node getContentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation);
    }

    private String getSize(Node node) {
        double size = this.getFileSize(node);
        try {
            if (node.hasNode("jcr:content")) {
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private double getFileSize(Node node) {
        double fileSize = 0.0;
        try {
            Node contentNode;
            if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
                fileSize = contentNode.getProperty("jcr:data").getLength();
            }
        }
        catch (Exception ex) {
            fileSize = 0.0;
        }
        return fileSize;
    }

    private String getWebdavURL() throws Exception {
        this.contentNode = this.getContentNode();
        FriendlyService friendlyService = (FriendlyService)WCMCoreUtils.getService(FriendlyService.class);
        String link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (this.contentNode.isNodeType("nt:frozenNode")) {
            String uuid = this.contentNode.getProperty("jcr:frozenUuid").getString();
            Node originalNode = this.contentNode.getSession().getNodeByUUID(uuid);
            link = this.baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + this.repository + "/" + this.workspace + originalNode.getPath() + "?version=" + this.contentNode.getParent().getName();
        } else {
            link = this.baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + this.repository + "/" + this.workspace + this.contentNode.getPath();
        }
        return friendlyService.getFriendlyUri(link);
    }

    private int getImageWidth(Node node) {
        int imageWidth = 0;
        try {
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            ImageReader reader = ImageIO.getImageReadersByMIMEType(this.mimeType).next();
            ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
            reader.setInput(iis, true);
            imageWidth = reader.getWidth(0);
            iis.close();
            reader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageWidth;
    }

    private int getImageHeight(Node node) {
        int imageHeight = 0;
        try {
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            ImageReader reader = ImageIO.getImageReadersByMIMEType(this.mimeType).next();
            ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
            reader.setInput(iis, true);
            imageHeight = reader.getHeight(0);
            iis.close();
            reader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageHeight;
    }

    private int getVersion(Node node) {
        String currentVersion = null;
        try {
            currentVersion = this.contentNode.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "0";
        }
        return Integer.parseInt(currentVersion);
    }
}

