/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.PasteManageComponent;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UIClipboard.gtmpl", events={@EventConfig(listeners={PasteActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}), @EventConfig(listeners={ClearAllActionListener.class})})
public class UIClipboard
extends UIComponent {
    public static final String[] CLIPBOARD_BEAN_FIELD = new String[]{"path"};
    public static final String[] CLIPBOARD_ACTIONS = new String[]{"Paste", "Delete"};
    private LinkedList<ClipboardCommand> clipboard_;

    public String[] getBeanFields() {
        return CLIPBOARD_BEAN_FIELD;
    }

    public String[] getBeanActions() {
        return CLIPBOARD_ACTIONS;
    }

    public LinkedList<ClipboardCommand> getClipboardData() throws Exception {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        this.clipboard_ = new LinkedList(clipboardService.getClipboardList(userId, false));
        return this.clipboard_;
    }

    public static class ClearAllActionListener
    extends EventListener<UIClipboard> {
        public void execute(Event<UIClipboard> event) {
            UIClipboard uiClipboard = (UIClipboard)((Object)event.getSource());
            uiClipboard.clipboard_.clear();
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
            clipboardService.clearClipboardList(userId, false);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIClipboard> {
        public void execute(Event<UIClipboard> event) throws Exception {
            UIClipboard uiClipboard = (UIClipboard)((Object)event.getSource());
            String itemIndex = event.getRequestContext().getRequestParameter("objectId");
            ClipboardCommand command = (ClipboardCommand)uiClipboard.clipboard_.remove(Integer.parseInt(itemIndex) - 1);
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
            clipboardService.getClipboardList(userId, false).remove(command);
        }
    }

    public static class PasteActionListener
    extends EventListener<UIClipboard> {
        public void execute(Event<UIClipboard> event) throws Exception {
            UIClipboard uiClipboard = (UIClipboard)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiClipboard.getAncestorOfType(UIJCRExplorer.class);
            String id = event.getRequestContext().getRequestParameter("objectId");
            int index = Integer.parseInt(id);
            ClipboardCommand selectedClipboard = (ClipboardCommand)uiClipboard.clipboard_.get(index - 1);
            Node node = uiExplorer.getCurrentNode();
            String nodePath = node.getPath();
            String wsName = node.getSession().getWorkspace().getName();
            UIApplication app = (UIApplication)uiClipboard.getAncestorOfType(UIApplication.class);
            try {
                PasteManageComponent.processPaste(selectedClipboard, wsName + ":" + nodePath, event);
                uiExplorer.updateAjax(event);
            }
            catch (PathNotFoundException path) {
                app.addMessage(new ApplicationMessage("PathNotFoundException.msg", null, 1));
                return;
            }
            catch (Exception e) {
                app.addMessage(new ApplicationMessage("UIClipboard.msg.unable-pasted", null, 1));
                return;
            }
        }
    }
}

