/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    NONE(null),
    XML_SCHEMA_INSTANCE("http://www.w3.org/2001/XMLSchema-instance"),
    INFINISPAN_5_0("urn:infinispan:config:5.0"),
    INFINISPAN_5_1("urn:infinispan:config:5.1");

    public static final Namespace CURRENT;
    private final String name;
    public static final EnumSet<Namespace> STANDARD_NAMESPACES;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        if (uri == null || "".equals(uri)) {
            return NONE;
        }
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = INFINISPAN_5_1;
        STANDARD_NAMESPACES = EnumSet.complementOf(EnumSet.of(UNKNOWN, XML_SCHEMA_INSTANCE));
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

