/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.io.MarshalledValueByteStream;

@ThreadSafe
public class ImmutableMarshalledValueByteStream
extends MarshalledValueByteStream {
    private final byte[] bytes;

    public ImmutableMarshalledValueByteStream(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public byte[] getRaw() {
        return this.bytes;
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException("Immutable");
    }

    public boolean equals(Object thatObject) {
        if (thatObject instanceof MarshalledValueByteStream) {
            MarshalledValueByteStream that = (MarshalledValueByteStream)thatObject;
            if (this == that) {
                return true;
            }
            byte[] thoseBytes = that.getRaw();
            if (this.bytes == thoseBytes) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.bytes[i] == thoseBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

