/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;

public final class SnuggleInput {
    private final InputType type;
    private String identifier;
    private URI uri;
    private final String string;
    private final File file;
    private final InputStream inputStream;
    private final Reader reader;
    private String stringRepresentation;

    public SnuggleInput(String string) {
        this(string, "\"" + string + "\"");
    }

    public SnuggleInput(String string, String identifier) {
        this(InputType.STRING, string, null, null, null, identifier);
    }

    public SnuggleInput(File file) {
        this(file, file.getPath());
    }

    public SnuggleInput(File file, String identifier) {
        this(InputType.FILE, null, file, null, null, identifier);
    }

    public SnuggleInput(InputStream inputStream) {
        this(inputStream, "[Stream input @" + inputStream.hashCode() + "]");
    }

    public SnuggleInput(InputStream inputStream, String identifier) {
        this(InputType.INPUT_STREAM, null, null, inputStream, null, identifier);
    }

    public SnuggleInput(Reader reader) {
        this(reader, "[Reader input @" + reader.hashCode() + "]");
    }

    public SnuggleInput(Reader reader, String identifier) {
        this(InputType.READER, null, null, null, reader, identifier);
    }

    private SnuggleInput(InputType type, String string, File file, InputStream inputStream, Reader reader, String identifier) {
        this.type = type;
        this.string = string;
        this.file = file;
        this.inputStream = inputStream;
        this.reader = reader;
        this.identifier = identifier;
    }

    public InputType getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String getString() {
        return this.string;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.buildStringRepresentation();
        }
        return this.stringRepresentation;
    }

    private String buildStringRepresentation() {
        return this.getClass().getSimpleName() + "(" + this.identifier + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputType {
        STRING,
        FILE,
        INPUT_STREAM,
        READER;

    }
}

