/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.notification.plugin;

import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class CalendarActivityChildPlugin
extends AbstractNotificationChildPlugin {
    public static final ArgumentLiteral<String> ACTIVITY_ID = new ArgumentLiteral(String.class, "activityId");
    public static final String ID = "cs-calendar:spaces";
    private ExoSocialActivity activity = null;

    public CalendarActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        try {
            ActivityManager activityM = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(ID, language);
            String activityId = notification.getValueOwnerParameter(ACTIVITY_ID.getKey());
            this.activity = activityM.getActivity(activityId);
            if (this.activity.isComment()) {
                this.activity = activityM.getParentActivity(this.activity);
            }
            templateContext.put((Object)"ACTIVITY", (Object)this.activity.getTitle());
            String content = TemplateUtils.processGroovy((TemplateContext)templateContext);
            return content;
        }
        catch (Exception e) {
            return this.activity != null ? this.activity.getTitle() : "";
        }
    }

    public String getActivityParamValue(String key) {
        Map params = this.activity.getTemplateParams();
        if (params != null) {
            return params.get(key) != null ? (String)params.get(key) : "";
        }
        return "";
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }
}

