/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public class StatementFusion
extends AbstractPeepholeOptimization {
    @Override
    Node optimizeSubtree(Node n) {
        if (!n.getParent().isFunction() && StatementFusion.canFuseIntoOneStatement(n)) {
            this.fuseIntoOneStatement(n);
            this.reportCodeChange();
        }
        return n;
    }

    private static boolean canFuseIntoOneStatement(Node block) {
        if (block.getType() != 125) {
            return false;
        }
        if (!block.hasChildren() || block.hasOneChild()) {
            return false;
        }
        Node last = block.getLastChild();
        for (Node c = block.getFirstChild(); c != null; c = c.getNext()) {
            if (NodeUtil.isExpressionNode(c) || c == last) continue;
            return false;
        }
        switch (last.getType()) {
            case 49: 
            case 108: 
            case 110: 
            case 130: {
                return true;
            }
            case 4: {
                return last.hasChildren();
            }
            case 115: {
                return NodeUtil.isForIn(last) && !NodeUtil.mayHaveSideEffects(last.getFirstChild());
            }
        }
        return false;
    }

    private void fuseIntoOneStatement(Node block) {
        Node cur = block.removeFirstChild();
        Node commaTree = cur.removeFirstChild();
        while (block.hasMoreThanOneChild()) {
            Node next = block.removeFirstChild().removeFirstChild();
            commaTree = StatementFusion.fuseExpressionIntoExpression(commaTree, next);
        }
        Preconditions.checkState((boolean)block.hasOneChild());
        Node last = block.getLastChild();
        switch (last.getType()) {
            case 4: 
            case 49: 
            case 108: 
            case 110: 
            case 130: {
                StatementFusion.fuseExpresssonIntoFirstChild(commaTree, last);
                return;
            }
            case 115: {
                if (NodeUtil.isForIn(last)) {
                    StatementFusion.fuseExpresssonIntoSecondChild(commaTree, last);
                }
                return;
            }
        }
        throw new IllegalStateException("Statement fusion missing.");
    }

    private static Node fuseExpressionIntoExpression(Node exp1, Node exp2) {
        Node comma = new Node(85, exp1);
        comma.copyInformationFrom(exp2);
        if (exp2.isComma()) {
            Node leftMostChild = exp2;
            while (leftMostChild.isComma()) {
                leftMostChild = leftMostChild.getFirstChild();
            }
            Node parent = leftMostChild.getParent();
            comma.addChildToBack(leftMostChild.detachFromParent());
            parent.addChildToFront(comma);
            return exp2;
        }
        comma.addChildToBack(exp2);
        return comma;
    }

    private static void fuseExpresssonIntoFirstChild(Node exp, Node stmt) {
        Node val = stmt.removeFirstChild();
        Node comma = StatementFusion.fuseExpressionIntoExpression(exp, val);
        stmt.addChildToFront(comma);
    }

    private static void fuseExpresssonIntoSecondChild(Node exp, Node stmt) {
        Node val = stmt.removeChildAfter(stmt.getFirstChild());
        Node comma = StatementFusion.fuseExpressionIntoExpression(exp, val);
        stmt.addChildAfter(comma, stmt.getFirstChild());
    }
}

