/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.io.Writer;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormScrollSelectBox
extends UIFormInputBase<String> {
    protected Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private String onchange_ = null;
    private int displayNumber_ = 10;
    private List<SelectItemOption<String>> options_;

    public UIFormScrollSelectBox() {
    }

    public UIFormScrollSelectBox(String name, String bindingExpression) {
        super(name, bindingExpression, String.class);
    }

    public UIFormScrollSelectBox(String name, String bindingExpression, String defaultValue) {
        super(name, bindingExpression, String.class);
        this.value_ = defaultValue;
        this.resetSelect();
    }

    public UIFormScrollSelectBox(String name, String bindingExpression, List<SelectItemOption<String>> options) {
        super(name, bindingExpression, null);
        this.setOptions(options);
        this.resetSelect();
    }

    public final UIFormScrollSelectBox setMaxDisplayOption(int maxDisplayOption) {
        this.displayNumber_ = maxDisplayOption;
        return this;
    }

    public int getMaxDisplayOption() {
        return this.displayNumber_;
    }

    public UIFormScrollSelectBox setValue(String value) {
        this.value_ = value;
        this.resetSelect();
        return this;
    }

    public final List<SelectItemOption<String>> getOptions() {
        return this.options_;
    }

    public final UIFormScrollSelectBox setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        if (this.options_ == null || this.options_.size() < 1) {
            return this;
        }
        this.value_ = this.options_.get(0).getValue();
        this.resetSelect();
        return this;
    }

    public String getOnchange() {
        return this.onchange_;
    }

    public UIFormScrollSelectBox setOnChange(String onchange) {
        this.onchange_ = onchange;
        return this;
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.onchange_ != null && this.onchange_.length() > 0) {
            return uiForm.event(this.onchange_, this.getId());
        }
        return "";
    }

    public void decode(Object input, WebuiRequestContext context) {
        String val = (String)input;
        if (val == null || val.length() == 0) {
            this.value_ = null;
            return;
        }
        this.value_ = val;
        this.resetSelect();
    }

    private void resetSelect() {
        if (this.value_ == null || ((String)this.value_).length() == 0 && this.options_.size() > 0) {
            this.options_.get(0).setSelected(true);
        } else {
            for (SelectItemOption<String> item : this.options_) {
                item.setSelected(((String)item.getValue()).equals(this.value_));
            }
        }
    }

    public String getSelectedValue() {
        SelectItemOption<String> option = this.getSelectedItem();
        return option != null ? (String)option.getValue() : null;
    }

    public String getSelectedLabel() {
        SelectItemOption<String> option = this.getSelectedItem();
        return option != null ? option.getLabel() : "";
    }

    public SelectItemOption<String> getSelectedItem() {
        for (SelectItemOption<String> item : this.options_) {
            if (!item.isSelected()) continue;
            return item;
        }
        return null;
    }

    private String getLabelOption(ResourceBundle res, String formId, SelectItemOption<String> option) {
        try {
            return res.getString(formId + ".option." + (String)option.getValue());
        }
        catch (MissingResourceException ex) {
            return option.getLabel();
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String formId = uiForm.getId();
        String clazzMaxSize = this.options_.size() > this.displayNumber_ ? " scroll-menu" : "";
        Writer w = context.getWriter();
        w.write("<div id=\"ScrollSelect");
        w.write(this.getId());
        w.write("\" ");
        this.renderHTMLAttributes(w);
        w.write(">");
        w.write("<input name=\"");
        w.write(this.getName());
        w.write("\"");
        w.write(" type=\"hidden\"");
        w.write(" id=\"");
        w.write(this.getId());
        w.write("\"");
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            this.value_ = HTMLEntityEncoder.getInstance().encodeHTMLAttribute((String)this.value_);
            w.write(" value=\"");
            w.write((String)this.value_);
            w.write("\"");
        }
        w.write("/>");
        w.write("  <div style=\"display:none\" class=\"selectInfoData\" data-onchange=\"");
        w.write(this.renderOnChangeEvent(uiForm));
        w.write("\" data-size=\"");
        w.write(this.displayNumber_);
        w.write("\" data-disabled=\"");
        w.write(String.valueOf(this.isDisabled()));
        w.write("\"></div>\n");
        String clazzDisable = this.isDisabled() ? "disabled " : " ";
        w.write("<div class=\"uiFormScrollMenu btn-group uiDropdownWithIcon" + clazzDisable + "clearfix\" ");
        this.renderHTMLAttributes(w);
        w.write(">\n");
        w.write("\t<div class=\"btn dropdown-toggle\">\n");
        w.write("\t\t<span>");
        w.write(this.getSelectedLabel());
        w.write("\t\t</span>\n");
        w.write("\t\t<span class=\"spiter\"></span>\n");
        w.write("\t\t<span class=\"caret\"></span>\n");
        w.write("  </div>\n");
        w.write("  <div class=\"optionMenu open" + clazzMaxSize + "\" style=\"position:absolute; visibility:hidden\">\n");
        w.write("    <ul class=\"option-list dropdown-menu\">\n");
        for (SelectItemOption<String> item : this.options_) {
            String label = this.getLabelOption(res, formId, item);
            String value = (String)item.getValue();
            value = HTMLEntityEncoder.getInstance().encodeHTMLAttribute(value);
            if (item.isSelected()) {
                w.write("      <li data-selected=\"true\" class=\"option\" data-value=\"" + value + "\">");
                w.write("        <a class=\"selected\" href=\"javascript:void(0);\">\n");
            } else {
                w.write("      <li class=\"option\" data-value=\"" + value + "\">");
                w.write("        <a href=\"javascript:void(0);\">\n");
            }
            w.write(label);
            w.write("</a>\n");
            w.write("</li>\n");
        }
        w.write("    </ul>\n");
        w.write("  </div>\n");
        w.write("</div>\n");
        if (this.isMandatory()) {
            w.write(" *");
        }
        w.write("</div>\n");
        context.getJavascriptManager().getRequireJS().require("SHARED/scrollSelectBox", "formScrollSelectBox").addScripts("formScrollSelectBox.init('ScrollSelect" + this.getId() + "');");
    }
}

