/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class SpaceInvitationPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "SpaceInvitationPlugin";

    public SpaceInvitationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Space space = (Space)ctx.value(SocialNotificationUtils.SPACE);
        String userId = (String)ctx.value(SocialNotificationUtils.REMOTE_ID);
        return NotificationInfo.instance().key(this.getId()).with(SocialNotificationUtils.PRETTY_NAME.getKey(), space.getPrettyName()).with(SocialNotificationUtils.SPACE_ID.getKey(), space.getId()).to(userId).end();
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
        Space space = Utils.getSpaceService().getSpaceById(spaceId);
        templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
        templateContext.put((Object)"SPACE_URL", (Object)LinkProviderUtils.getRedirectUrl("space", space.getId()));
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        templateContext.put((Object)"SPACE_AVATAR", (Object)LinkProviderUtils.getSpaceAvatarUrl(space));
        templateContext.put((Object)"ACCEPT_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getAcceptInvitationToJoinSpaceUrl(space.getId(), notification.getTo()));
        templateContext.put((Object)"REFUSE_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getIgnoreInvitationToJoinSpaceUrl(space.getId(), notification.getTo()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo message : notifications) {
                String spaceId = message.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
                Space space = Utils.getSpaceService().getSpaceById(spaceId);
                if (!ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)first.getTo())) continue;
                SocialNotificationUtils.processInforSendTo(receiverMap, first.getTo(), spaceId);
            }
            writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext, "space"));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }
}

