/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.Map;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRequestBridge;
import juzu.impl.common.MimeType;
import juzu.impl.request.Method;
import juzu.request.ClientContext;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebActionBridge
extends WebRequestBridge
implements ActionBridge {
    WebActionBridge(Bridge bridge, Handler handler, WebBridge http, Method<?> target, Map<String, String[]> parameters) {
        super(bridge, handler, http, target, parameters);
    }

    @Override
    public ClientContext getClientContext() {
        return this.http.getClientContext();
    }

    @Override
    boolean send() throws IOException {
        if (super.send()) {
            return true;
        }
        if (this.response instanceof Response.View) {
            Response.View update = (Response.View)this.response;
            DispatchSPI spi = this.createDispatch(Phase.VIEW, update.getTarget(), update.getParameters());
            Phase.View.Dispatch dispatch = new Phase.View.Dispatch(spi);
            String url = dispatch.with(MimeType.PLAIN).with(update.getProperties()).toString();
            Iterable<Map.Entry<String, String[]>> headers = this.response.getProperties().getValues(PropertyType.HEADER);
            if (headers != null) {
                for (Map.Entry<String, String[]> entry : headers) {
                    this.http.setHeader(entry.getKey(), entry.getValue()[0]);
                }
            }
            this.http.sendRedirect(url);
            return true;
        }
        if (this.response instanceof Response.Redirect) {
            Response.Redirect redirect = (Response.Redirect)this.response;
            String url = redirect.getLocation();
            this.http.sendRedirect(url);
            return true;
        }
        return false;
    }
}

