/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.inject.Singleton;
import juzu.Scope;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.Container;
import juzu.impl.inject.spi.cdi.ContextImpl;
import juzu.impl.inject.spi.cdi.SingletonBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
implements Extension {
    private final CDIContext manager = CDIContext.boot.get();
    private List<Bean<?>> singletons = new ArrayList();

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        if (this.manager != null) {
            boolean veto;
            AnnotatedType annotatedType = pat.getAnnotatedType();
            Class type = annotatedType.getJavaClass();
            boolean bl = veto = !this.manager.filter.accept(type);
            if (!veto) {
                for (AbstractBean boundBean : this.manager.boundBeans) {
                    Class<?> beanType = boundBean.getBeanClass();
                    if (!beanType.isAssignableFrom(type)) continue;
                    veto = true;
                    break;
                }
            }
            if (veto) {
                pat.veto();
            }
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (this.manager != null) {
            Container container = Container.boot.get();
            for (Scope scope : container.scopes) {
                if (scope.isBuiltIn()) continue;
                event.addContext((Context)new ContextImpl(container.scopeController, scope, scope.getAnnotationType()));
            }
            event.addBean((Bean)new SingletonBean(InjectionContext.class, Tools.set(AbstractBean.DEFAULT_QUALIFIER, AbstractBean.ANY_QUALIFIER), this.manager));
            for (AbstractBean bean : this.manager.boundBeans) {
                bean.register(beanManager);
                event.addBean((Bean)bean);
            }
        }
    }

    void processBean(@Observes ProcessBean event, BeanManager beanManager) {
        if (this.manager != null) {
            Bean bean = event.getBean();
            this.manager.beans.add(bean);
            if (bean.getScope() == Singleton.class) {
                this.singletons.add(bean);
            }
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
        if (this.manager != null) {
            for (Bean<?> singleton : this.singletons) {
                CreationalContext cc = beanManager.createCreationalContext(singleton);
                Object o = beanManager.getReference(singleton, (Type)singleton.getBeanClass(), cc);
                singleton.destroy(o, cc);
            }
        }
    }
}

