/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingProxyUriManager;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanitizingGadgetRewriter
extends DomWalker.Rewriter {
    private static final String BYPASS_SANITIZATION_KEY = "shindig.bypassSanitization";
    private static UserDataHandler copyOnClone = new UserDataHandler(){

        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (operation == 2 || operation == 1) {
                dst.setUserData(key, data, copyOnClone);
            }
        }
    };

    public static boolean isSanitizedRenderingRequest(Gadget gadget) {
        return "1".equals(gadget.getContext().getParameter("sanitize"));
    }

    public static void bypassSanitization(Element element, boolean includingChildren) {
        element.setUserData(BYPASS_SANITIZATION_KEY, (Object)(includingChildren ? Bypass.ALL : Bypass.ONLY_SELF), copyOnClone);
    }

    @Inject
    public SanitizingGadgetRewriter(@AllowedTags Set<String> allowedTags, @AllowedAttributes Set<String> allowedAttributes, ContentRewriterFeature.Factory rewriterFeatureFactory, CajaCssSanitizer cssSanitizer, ProxyUriManager proxyUriManager) {
        super(new BasicElementFilter(allowedTags, allowedAttributes), new LinkSchemeCheckFilter(), new StyleFilter(proxyUriManager, cssSanitizer), new LinkFilter(proxyUriManager), new ImageFilter(proxyUriManager), new TargetFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewrite(Gadget gadget, MutableContent content) throws RewritingException {
        if (gadget.sanitizeOutput()) {
            boolean sanitized = false;
            try {
                super.rewrite(gadget, content);
                sanitized = true;
            }
            finally {
                if (!sanitized) {
                    content.setContent("");
                }
            }
        }
    }

    private static List<Attr> toList(NamedNodeMap nodes) {
        ArrayList<Attr> list = new ArrayList<Attr>(nodes.getLength());
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            list.add((Attr)nodes.item(i));
        }
        return list;
    }

    public static Bypass canBypassSanitization(Element element) {
        Bypass bypass = (Bypass)((Object)element.getUserData(BYPASS_SANITIZATION_KEY));
        if (bypass == null) {
            bypass = Bypass.NONE;
        }
        return bypass;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    @BindingAnnotation
    public static @interface AllowedAttributes {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    @BindingAnnotation
    public static @interface AllowedTags {
    }

    static class TargetFilter
    extends SanitizingWalker {
        TargetFilter() {
        }

        protected boolean removeTag(Gadget gadget, Element elem, Uri ctx) {
            return false;
        }

        protected boolean removeAttr(Gadget gadget, Attr attr, Uri ctx) {
            String value;
            return "target".equalsIgnoreCase(attr.getName()) && !"_blank".equals(value = attr.getValue().toLowerCase()) && !"_self".equals(value);
        }
    }

    static final class LinkFilter
    extends SanitizingWalker {
        private final SanitizingProxyUriManager cssImportRewriter;

        private LinkFilter(ProxyUriManager proxyUriManager) {
            this.cssImportRewriter = new SanitizingProxyUriManager(proxyUriManager, "text/css");
        }

        protected boolean removeTag(Gadget gadget, Element elem, Uri ctx) {
            if (!elem.getNodeName().equalsIgnoreCase("link")) {
                return false;
            }
            boolean hasType = false;
            for (Attr attr : SanitizingGadgetRewriter.toList(elem.getAttributes())) {
                if ("rel".equalsIgnoreCase(attr.getName())) {
                    hasType |= "stylesheet".equalsIgnoreCase(attr.getValue());
                    continue;
                }
                if ("type".equalsIgnoreCase(attr.getName())) {
                    hasType |= "text/css".equalsIgnoreCase(attr.getValue());
                    continue;
                }
                if (!"href".equalsIgnoreCase(attr.getName())) continue;
                try {
                    ProxyUriManager.ProxyUri proxiedUri = ProxyUriManager.ProxyUri.fromList(gadget, (List<Uri>)ImmutableList.of((Object)Uri.parse((String)attr.getValue()))).get(0);
                    proxiedUri.setHtmlTagContext(elem.getNodeName().toLowerCase());
                    attr.setValue(this.cssImportRewriter.make((List<ProxyUriManager.ProxyUri>)ImmutableList.of((Object)proxiedUri), null).get(0).toString());
                }
                catch (IllegalArgumentException e) {
                    return true;
                }
            }
            return !hasType;
        }

        protected boolean removeAttr(Gadget gadget, Attr attr, Uri ctx) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StyleFilter
    implements DomWalker.Visitor {
        private final SanitizingProxyUriManager imageRewriter;
        private final SanitizingProxyUriManager cssImportRewriter;
        private final CajaCssSanitizer cssSanitizer;

        private StyleFilter(ProxyUriManager proxyUriManager, CajaCssSanitizer cssSanitizer) {
            this.imageRewriter = new SanitizingProxyUriManager(proxyUriManager, "image/*");
            this.cssImportRewriter = new SanitizingProxyUriManager(proxyUriManager, "text/css");
            this.cssSanitizer = cssSanitizer;
        }

        @Override
        public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
            if (node.getNodeType() == 1 && "style".equalsIgnoreCase(node.getNodeName())) {
                this.cssSanitizer.sanitize((Element)node, gadget.getSpec().getUrl(), gadget.getContext(), (ProxyUriManager)this.cssImportRewriter, (ProxyUriManager)this.imageRewriter);
                return DomWalker.Visitor.VisitStatus.MODIFY;
            }
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }

        @Override
        public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
            return false;
        }
    }

    static final class ImageFilter
    extends SanitizingWalker {
        private final SanitizingProxyUriManager imageRewriter;

        private ImageFilter(ProxyUriManager proxyUriManager) {
            this.imageRewriter = new SanitizingProxyUriManager(proxyUriManager, "image/*");
        }

        protected boolean removeTag(Gadget gadget, Element elem, Uri ctx) {
            return false;
        }

        protected boolean removeAttr(Gadget gadget, Attr attr, Uri ctx) {
            if ("img".equalsIgnoreCase(attr.getOwnerElement().getNodeName()) && "src".equalsIgnoreCase(attr.getName())) {
                try {
                    Uri uri = Uri.parse((String)attr.getValue());
                    ProxyUriManager.ProxyUri proxiedUri = ProxyUriManager.ProxyUri.fromList(gadget, (List<Uri>)ImmutableList.of((Object)uri)).get(0);
                    proxiedUri.setHtmlTagContext(attr.getOwnerElement().getNodeName().toLowerCase());
                    attr.setValue(this.imageRewriter.make((List<ProxyUriManager.ProxyUri>)ImmutableList.of((Object)proxiedUri), null).get(0).toString());
                }
                catch (IllegalArgumentException e) {
                    return true;
                }
            }
            return false;
        }
    }

    static class LinkSchemeCheckFilter
    extends SanitizingWalker {
        private static final Set<String> URI_ATTRIBUTES = ImmutableSet.of((Object)"href", (Object)"src");

        LinkSchemeCheckFilter() {
        }

        protected boolean removeTag(Gadget gadget, Element elem, Uri ctx) {
            return false;
        }

        protected boolean removeAttr(Gadget gadget, Attr attr, Uri ctx) {
            if (URI_ATTRIBUTES.contains(attr.getName().toLowerCase())) {
                try {
                    Uri uri = Uri.parse((String)attr.getValue());
                    String scheme = uri.getScheme();
                    if (scheme != null && !scheme.equals("http") && !scheme.equals("https")) {
                        return true;
                    }
                }
                catch (IllegalArgumentException iae) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BasicElementFilter
    extends SanitizingWalker {
        private final Set<String> allowedTags;
        private final Set<String> allowedAttributes;

        private BasicElementFilter(Set<String> allowedTags, Set<String> allowedAttributes) {
            this.allowedTags = allowedTags;
            this.allowedAttributes = allowedAttributes;
        }

        @Override
        public boolean removeTag(Gadget gadget, Element elem, Uri context) {
            return !this.allowedTags.contains(elem.getNodeName().toLowerCase());
        }

        @Override
        public boolean removeAttr(Gadget gadget, Attr attr, Uri context) {
            return !this.allowedAttributes.contains(attr.getName().toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SanitizingWalker
    implements DomWalker.Visitor {
        private SanitizingWalker() {
        }

        protected abstract boolean removeTag(Gadget var1, Element var2, Uri var3);

        protected abstract boolean removeAttr(Gadget var1, Attr var2, Uri var3);

        @Override
        public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
            Element elem = null;
            switch (node.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    return DomWalker.Visitor.VisitStatus.BYPASS;
                }
                case 1: 
                case 9: {
                    elem = (Element)node;
                    break;
                }
                default: {
                    return DomWalker.Visitor.VisitStatus.RESERVE_TREE;
                }
            }
            Bypass bypass = SanitizingGadgetRewriter.canBypassSanitization(elem);
            if (bypass == Bypass.ALL) {
                return DomWalker.Visitor.VisitStatus.RESERVE_TREE;
            }
            if (bypass == Bypass.ONLY_SELF) {
                return DomWalker.Visitor.VisitStatus.BYPASS;
            }
            if (this.removeTag(gadget, elem, gadget.getSpec().getUrl())) {
                return DomWalker.Visitor.VisitStatus.RESERVE_TREE;
            }
            DomWalker.Visitor.VisitStatus status = DomWalker.Visitor.VisitStatus.MODIFY;
            for (Attr attr : SanitizingGadgetRewriter.toList(elem.getAttributes())) {
                if (!this.removeAttr(gadget, attr, gadget.getSpec().getUrl())) continue;
                elem.removeAttributeNode(attr);
            }
            return status;
        }

        @Override
        public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
            for (Node node : nodes) {
                if (node.getNodeType() != 8 && SanitizingGadgetRewriter.canBypassSanitization((Element)node) == Bypass.ALL) continue;
                node.getParentNode().removeChild(node);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Bypass {
        ALL,
        ONLY_SELF,
        NONE;

    }
}

