/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clipboard.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ClipboardServiceImpl
implements ClipboardService {
    private static final String CLIPBOARD_CACHE = "ClipboardServiceCache";
    private static final String CLIPBOARD_CACHE_VIRTUAL = "ClipboardServiceCacheVirtual";
    private CacheService cacheService_;
    private Map<String, Map<String, ClipboardCommand>> repoLastCommand_;
    private int liveTime_;
    private int maxSize_;

    public ClipboardServiceImpl(CacheService cacheService, InitParams initParams) {
        this.cacheService_ = cacheService;
        this.repoLastCommand_ = new HashMap<String, Map<String, ClipboardCommand>>();
        this.liveTime_ = Integer.parseInt(initParams.getValueParam("liveTime").getValue());
        this.maxSize_ = Integer.parseInt(initParams.getValueParam("maxSize").getValue());
    }

    @Override
    public void addClipboardCommand(String userId, ClipboardCommand command, boolean isVirtual) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        ExoCache<String, Set<ClipboardCommand>> cache = isVirtual ? virtualCache_ : cache_;
        LinkedHashSet<ClipboardCommand> commands = (LinkedHashSet<ClipboardCommand>)cache.get((Serializable)((Object)userId));
        if (commands != null) {
            commands.add(command);
        } else {
            commands = new LinkedHashSet<ClipboardCommand>();
            commands.add(command);
            cache.put((Serializable)((Object)userId), commands);
        }
        if (!isVirtual) {
            lastCommand_.put(userId, command);
        }
    }

    @Override
    public ClipboardCommand getLastClipboard(String userId) {
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        return lastCommand_.get(userId);
    }

    @Override
    public Set<ClipboardCommand> getClipboardList(String userId, boolean isVirtual) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        ExoCache<String, Set<ClipboardCommand>> cache = isVirtual ? virtualCache_ : cache_;
        Set ret = (Set)cache.get((Serializable)((Object)userId));
        return ret != null ? ret : new LinkedHashSet();
    }

    @Override
    public void clearClipboardList(String userId, boolean isVirtual) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        ExoCache<String, Set<ClipboardCommand>> cache = isVirtual ? virtualCache_ : cache_;
        Set commands = (Set)cache.get((Serializable)((Object)userId));
        if (commands != null) {
            commands.clear();
        }
        lastCommand_.remove(userId);
    }

    private ExoCache<String, Set<ClipboardCommand>> getVirtualCache() {
        ExoCache ret = this.cacheService_.getCacheInstance(CLIPBOARD_CACHE_VIRTUAL + this.getRepoName());
        ret.setLiveTime((long)this.liveTime_);
        ret.setMaxSize(this.maxSize_);
        return ret;
    }

    private ExoCache<String, Set<ClipboardCommand>> getCache() {
        ExoCache ret = this.cacheService_.getCacheInstance(CLIPBOARD_CACHE + this.getRepoName());
        ret.setLiveTime((long)this.liveTime_);
        ret.setMaxSize(this.maxSize_);
        return ret;
    }

    private Map<String, ClipboardCommand> getLastCommandMap() {
        Map<String, ClipboardCommand> ret = this.repoLastCommand_.get(this.getRepoName());
        if (ret == null) {
            ret = new HashMap<String, ClipboardCommand>();
            this.repoLastCommand_.put(this.getRepoName(), ret);
        }
        return ret;
    }

    private String getRepoName() {
        return WCMCoreUtils.getRepository().getConfiguration().getName();
    }
}

