/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class PayloadTypeBox
extends AbstractBox {
    public static final String TYPE = "payt";
    long payloadNumber;
    String rtpMapString;

    public PayloadTypeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return PayloadTypeBox.utf8StringLengthInBytes(this.rtpMapString) + 5;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.payloadNumber = in.readUInt32();
        int count = in.readUInt8();
        this.rtpMapString = in.readString(count);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.payloadNumber);
        os.writeUInt8(this.rtpMapString.length());
        os.writeStringNoTerm(this.rtpMapString);
    }

    public long getPayloadNumber() {
        return this.payloadNumber;
    }

    public void setPayloadNumber(long payloadNumber) {
        this.payloadNumber = payloadNumber;
    }

    public String getRtpMapString() {
        return this.rtpMapString;
    }

    public void setRtpMapString(String rtpMapString) {
        this.rtpMapString = rtpMapString;
    }
}

