/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.navigation.component.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;

public class DashboardUtils {
    private static UserNodeFilterConfig toolbarFilterConfig;
    private static final Log LOG;

    public static String getDashboardURL() throws Exception {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL dashboardUrl = (NodeURL)ctx.createURL(NodeURL.TYPE);
        UserNode dashboardNode = DashboardUtils.findDashboardNode();
        if (dashboardNode != null) {
            return dashboardUrl.setNode(dashboardNode).toString();
        }
        dashboardUrl.setResource(new NavigationResource(SiteType.USER, DashboardUtils.getCurrentUser(), null));
        return dashboardUrl.toString();
    }

    public static UserNavigation getCurrentUserNavigation() throws Exception {
        return DashboardUtils.getNavigation(SiteKey.user((String)DashboardUtils.getCurrentUser()));
    }

    public static String getCurrentUser() {
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return rcontext.getRemoteUser();
    }

    private static UserNavigation getNavigation(SiteKey userKey) {
        UserPortal userPortal = DashboardUtils.getUserPortal();
        return userPortal.getNavigation(userKey);
    }

    public static Collection<UserNode> getUserNodes(UserNavigation nav) {
        UserPortal userPortall = DashboardUtils.getUserPortal();
        if (nav != null) {
            try {
                UserNode rootNode = userPortall.getNode(nav, Scope.CHILDREN, toolbarFilterConfig, null);
                return rootNode.getChildren();
            }
            catch (Exception exp) {
                LOG.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return Collections.emptyList();
    }

    public static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }

    private static UserNode findDashboardNode() throws Exception {
        Collection<UserNode> nodes = DashboardUtils.getUserNodes(DashboardUtils.getCurrentUserNavigation());
        if (nodes == null) {
            return null;
        }
        Iterator<UserNode> i = nodes.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    static {
        LOG = ExoLogger.getExoLogger(DashboardUtils.class);
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL}).withTemporalCheck();
        toolbarFilterConfig = builder.build();
    }
}

