/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.navigation.component.utils;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.controller.QualifiedName;

public class NavigationUtils {
    private static final Log LOG = ExoLogger.getLogger(NavigationUtils.class);

    public static String getCurrentUser() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        PortalRequestContext request = Util.getPortalRequestContext();
        String currentPath = request.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
        String[] splitCurrentUser = currentPath.split("/");
        String currentUserName = currentPath.split("/")[splitCurrentUser.length - 1];
        try {
            if (currentUserName != null && idm.getOrCreateIdentity("organization", currentUserName, false) != null) {
                return currentUserName;
            }
            currentUserName = currentPath.split("/")[splitCurrentUser.length - 2];
            if (currentUserName != null && idm.getOrCreateIdentity("organization", currentUserName, false) != null) {
                return currentUserName;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Could not found Identity of user " + currentUserName));
            }
            return null;
        }
        return null;
    }
}

