/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.ArrayNodePageList;
import org.exoplatform.services.wcm.search.base.LazyPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.QueryResultPageList;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PageListFactory {
    private static final Log LOG = ExoLogger.getLogger((String)PageListFactory.class.getName());

    public static <E> AbstractPageList<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, int pageSize, int bufferSize, QueryCriteria criteria) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (bufferSize < pageSize) {
            bufferSize = Math.max(pageSize, 100);
        }
        SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(workspace, WCMCoreUtils.getRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStatement, language);
        int offset = 0;
        if (criteria != null) {
            if (criteria.getOffset() > 0L) {
                ((QueryImpl)query).setOffset(criteria.getOffset());
            } else {
                if (criteria.getOffset() < 0L) {
                    criteria.setOffset(0L);
                }
                SiteSearchService searchService = (SiteSearchService)WCMCoreUtils.getService(SiteSearchService.class);
                searchService.clearCache(ConversationState.getCurrent().getIdentity().getUserId(), queryStatement);
            }
            offset = (int)criteria.getOffset();
        }
        ((QueryImpl)query).setLimit(101L);
        QueryResult result = query.execute();
        int totalNodes = (int)result.getNodes().getSize();
        QueryData queryData = new QueryData(queryStatement, workspace, language, isSystemSession, offset);
        if (totalNodes <= 100) {
            return new ArrayNodePageList<E>(result, pageSize, filter, dataCreator, queryData);
        }
        QueryResultPageList ret = new QueryResultPageList(pageSize, queryData, totalNodes, bufferSize, filter, dataCreator);
        return ret;
    }

    public static <E> AbstractPageList<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, int pageSize, int bufferSize) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return PageListFactory.createPageList(queryStatement, workspace, language, isSystemSession, filter, dataCreator, pageSize, bufferSize, null);
    }

    public static <E> AbstractPageList<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return PageListFactory.createPageList(queryStatement, workspace, language, isSystemSession, filter, dataCreator, 10, 100);
    }

    public static <E> AbstractPageList<E> createPageList(List<Node> nodes, int pageSize, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) {
        return new ArrayNodePageList<E>(nodes, pageSize, filter, dataCreator);
    }

    public static <E> List<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, SearchDataCreator<E> dataCreator) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        ArrayList<E> dataList;
        block3: {
            SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
            Session session = sessionProvider.getSession(workspace, WCMCoreUtils.getRepository());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryStatement, language);
            QueryResult queryResult = query.execute();
            dataList = new ArrayList<E>();
            try {
                NodeIterator nodeIterator = queryResult.getNodes();
                RowIterator rowIterator = queryResult.getRows();
                while (nodeIterator.hasNext()) {
                    E data;
                    Node node = nodeIterator.nextNode();
                    Row row = rowIterator.nextRow();
                    if (dataCreator == null || node == null || (data = dataCreator.createData(node, row)) == null) continue;
                    dataList.add(data);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)e.getMessage());
            }
        }
        return dataList;
    }

    public static <E> LazyPageList<E> createLazyPageList(QueryData queryData, int nodePerPage, SearchDataCreator<E> dataCreator) {
        return new LazyPageList<E>(queryData, nodePerPage, dataCreator);
    }
}

