/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.connector.BaseContentSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class DocumentSearchServiceConnector
extends BaseContentSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger((String)DocumentSearchServiceConnector.class.getName());

    public DocumentSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    @Override
    protected String[] getSearchedDocTypes() {
        List docTypes;
        block2: {
            docTypes = null;
            try {
                docTypes = ((TemplateService)WCMCoreUtils.getService(TemplateService.class)).getDocumentTemplates();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        docTypes.remove("nt:file");
        return docTypes.toArray(new String[0]);
    }

    @Override
    protected String[] getNodeTypes() {
        return null;
    }

    @Override
    protected ResultNode filterNode(ResultNode node) throws RepositoryException {
        return node.isNodeType("nt:file") ? null : node;
    }

    @Override
    protected String getPath(DriveData driveData, ResultNode node, SearchContext context) throws Exception {
        String url = "#";
        String handler = WCMCoreUtils.getPortalName();
        UserPortalConfig prc = DocumentSearchServiceConnector.getUserPortalConfig();
        if (prc == null) {
            return null;
        }
        SiteKey siteKey = SiteKey.portal((String)prc.getPortalConfig().getName());
        if (siteKey != null && StringUtils.isNotBlank((String)siteKey.getName())) {
            String pageName = this.getPageName(siteKey);
            if (StringUtils.isNotBlank((String)pageName)) {
                siteKey = SiteKey.portal((String)(context.getSiteName() != null ? context.getSiteName() : "intranet"));
                pageName = this.getPageName(siteKey);
            }
            url = "/" + handler + context.handler(handler).lang("").siteName(siteKey.getName()).siteType(SiteType.PORTAL.getName()).path(pageName + "?path=" + driveData.getName() + "/" + node.getPath()).renderLink();
        }
        return URLDecoder.decode(url, "UTF-8");
    }

    private String getPageName(SiteKey siteKey) throws Exception {
        NavigationContext nav;
        NavigationService navService = (NavigationService)WCMCoreUtils.getService(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(siteKey), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!this.hasPortlet(child, "FileExplorerPortlet")) continue;
                return child.getName();
            }
        }
        return "";
    }

    private static UserPortalConfig getUserPortalConfig() throws Exception {
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = ConversationState.getCurrent().getIdentity().getUserId();
        UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
        return userPortalCfg;
    }

    private boolean hasPortlet(NodeContext<?> pageCt, String plName) {
        if (plName == null) {
            return false;
        }
        DataStorage ds = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        try {
            for (ModelObject mo : ds.getPage(pageCt.getState().getPageRef().format()).getChildren()) {
                if (!this.containApp(mo, plName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    private boolean containApp(ModelObject mo, String plName) {
        block6: {
            DataStorage ds = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
            if (mo instanceof Application) {
                try {
                    if (ds.getId(((Application)mo).getState()).contains(plName)) {
                        return true;
                    }
                    break block6;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (mo instanceof Container) {
                for (ModelObject m : ((Container)mo).getChildren()) {
                    if (!this.containApp(m, plName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

