/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.process;

import java.io.Writer;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;

public abstract class MessageProcess {
    private MessageProcess next;

    public void setNext(MessageProcess next) {
        this.next = next;
    }

    public MessageProcess getNext() {
        return this.next;
    }

    public void process(UserSetting setting, NotificationInfo notification, Writer out) {
        if (this.isValid(setting, notification)) {
            this.doProcess(setting, notification);
            this.processNext(setting, notification, out);
        }
    }

    private void processNext(UserSetting setting, NotificationInfo notification, Writer out) {
        if (this.getNext().isValid(setting, notification) && this.getNext() != null) {
            this.getNext().process(setting, notification, out);
        }
    }

    abstract void doProcess(UserSetting var1, NotificationInfo var2);

    abstract boolean isValid(UserSetting var1, NotificationInfo var2);
}

