/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.simple;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.simple.ui.UIPublishingPanel;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

@Deprecated
public class SimplePublicationPlugin
extends WebpagePublicationPlugin {
    public static final String DEFAULT_STATE = "draft";
    public static final String PUBLICATION = "publication:publication";
    public static final String LIFECYCLE_PROP = "publication:lifecycleName";
    public static final String CURRENT_STATE = "publication:currentState";
    public static final String HISTORY = "publication:history";
    public static final String WCM_PUBLICATION_MIXIN = "publication:simplePublication";
    public static final String LIFECYCLE_NAME = "Simple publication";
    private static final String LOCALE_FILE = "locale.services.publication.lifecycle.simple.SimplePublication";
    public static final String IMG_PATH = "artifacts/";
    private static final int BUFFER_SIZE = 512;

    public String getLifecycleType() {
        return WCM_PUBLICATION_MIXIN;
    }

    public void addMixin(Node node) throws Exception {
        node.addMixin(WCM_PUBLICATION_MIXIN);
    }

    public boolean canAddMixin(Node node) throws Exception {
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        if (runningPortals.size() == 0) {
            throw new AccessControlException("Current user doesn't have access permission to any portal");
        }
        if (node.isLocked()) {
            throw new LockException("This node is locked");
        }
        if (!node.isCheckedOut()) {
            throw new VersionException("This node is checked-in");
        }
        return node.canAddMixin(WCM_PUBLICATION_MIXIN);
    }

    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        Session session = node.getSession();
        node.setProperty(CURRENT_STATE, newState);
        PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        if (newState.equals(DEFAULT_STATE)) {
            String lifecycleName = node.getProperty(LIFECYCLE_PROP).getString();
            String[] logs = new String[]{new Date().toString(), DEFAULT_STATE, session.getUserID(), "PublicationService.SimplePublicationPlugin.changeState.enrolled", lifecycleName};
            publicationService.addLog(node, logs);
        } else if (newState.equals("published")) {
            String[] logs = new String[]{new Date().toString(), "published", session.getUserID(), "PublicationService.SimplePublicationPlugin.changeState.published"};
            publicationService.addLog(node, logs);
        } else if (newState.equals("enrolled")) {
            String[] logs = new String[]{new Date().toString(), "enrolled", session.getUserID(), "PublicationService.SimplePublicationPlugin.changeState.published"};
            publicationService.addLog(node, logs);
        } else {
            throw new Exception("WCMPublicationPlugin.changeState : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
        }
        session.save();
    }

    public String[] getPossibleStates() {
        return new String[]{"enrolled", DEFAULT_STATE, "published"};
    }

    public byte[] getStateImage(Node node, Locale locale) throws IOException, FileNotFoundException, Exception {
        byte[] bytes = null;
        StringBuffer fileName = new StringBuffer("WCM");
        String currentState = node.getProperty(CURRENT_STATE).getString();
        if ("published".equals(currentState)) {
            fileName.append("Published");
        } else {
            fileName.append("Unpublished");
        }
        String fileNameLocalized = fileName.toString() + "_" + locale.getLanguage();
        String completeFileName = IMG_PATH + fileNameLocalized + ".gif";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        if (in == null) {
            completeFileName = IMG_PATH + fileName + ".gif";
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimplePublicationPlugin.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIPublishingPanel form = (UIPublishingPanel)component.createUIComponent(UIPublishingPanel.class, null, null);
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        String portalName = this.getPortalForContent(node);
        form.initPanel(node, portalName, runningPortals);
        return form;
    }

    public String getUserInfo(Node node, Locale locale) throws Exception {
        return null;
    }

    private List<String> getRunningPortals(String userId) throws Exception {
        POMSessionManager manager = (POMSessionManager)WCMCoreUtils.getService(POMSessionManager.class);
        POMSession session = null;
        if (manager.getSession() == null) {
            session = manager.openSession();
        }
        ArrayList<String> listPortalName = new ArrayList<String>();
        DataStorage service = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        ListAccess pageList = service.find2(query);
        List portalConfigs = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)pageList);
        UserACL userACL = (UserACL)WCMCoreUtils.getService(UserACL.class);
        for (PortalConfig portalConfig : portalConfigs) {
            if (!userACL.hasPermission(portalConfig)) continue;
            listPortalName.add(portalConfig.getName());
        }
        if (session != null) {
            session.close();
        }
        return listPortalName;
    }

    public List<String> getListUserNavigationUri(Page page, String remoteUser) throws Exception {
        ArrayList<String> listPageNavigationUri = new ArrayList<String>();
        for (String portalName : this.getRunningPortals(remoteUser)) {
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
            UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, remoteUser, PortalRequestContext.USER_PORTAL_CONTEXT);
            UserPortal userPortal = userPortalCfg.getUserPortal();
            List navigationList = userPortal.getNavigations();
            for (UserNavigation nav : navigationList) {
                UserNode root = userPortal.getNode(nav, Scope.ALL, null, null);
                List userNodeList = PublicationUtil.findUserNodeByPageId((UserNode)root, (String)page.getPageId());
                for (UserNode node : userNodeList) {
                    listPageNavigationUri.add(PublicationUtil.setMixedNavigationUri((String)portalName, (String)node.getURI()));
                }
            }
        }
        return listPageNavigationUri;
    }

    private String getPortalForContent(Node contentNode) throws Exception {
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
        for (String portalPath : livePortalManagerService.getLivePortalsPath()) {
            if (!contentNode.getPath().startsWith(portalPath)) continue;
            return livePortalManagerService.getPortalNameByPath(portalPath);
        }
        return null;
    }

    public Node getNodeView(Node node, Map<String, Object> context) throws Exception {
        WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        String contentState = wcmPublicationService.getContentState(node);
        if ("obsolete".equals(contentState)) {
            return null;
        }
        if ("Edit".equals(context.get("filter-mode"))) {
            return node;
        }
        if (!DEFAULT_STATE.equals(contentState)) {
            return node;
        }
        return null;
    }

    public String getLocalizedAndSubstituteMessage(Locale locale, String key, String[] values) throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundleService bundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = bundleService.getResourceBundle(LOCALE_FILE, locale, cl);
        String result = "";
        try {
            result = resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = key;
        }
        if (values != null) {
            return String.format(result, values);
        }
        return result;
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser) throws Exception {
        this.updateLifecyleOnChangeContent(node, remoteUser, DEFAULT_STATE);
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser, String newState) throws Exception {
        String state = node.getProperty(CURRENT_STATE).getString();
        if (DEFAULT_STATE.equalsIgnoreCase(state) && DEFAULT_STATE.equals(newState)) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        this.changeState(node, newState, context);
    }
}

