/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.Version;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionData;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionLog;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

@Deprecated
public class StageAndVersionPublicationPlugin
extends WebpagePublicationPlugin {
    private WCMComposer composer;
    private ListenerService listenerService;
    private ActivityCommonService activityService;

    public StageAndVersionPublicationPlugin() {
        WCMCoreUtils.getService(DataStorage.class);
        WCMCoreUtils.getService(POMSessionManager.class);
        this.composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
        this.listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
        this.activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
    }

    public String getLifecycleType() {
        return "publication:stateAndVersionBasedPublication";
    }

    public void addMixin(Node node) throws Exception {
        node.addMixin("publication:stateAndVersionBasedPublication");
        if (!node.isNodeType("mix:versionable")) {
            node.addMixin("mix:versionable");
        }
    }

    public boolean canAddMixin(Node node) throws Exception {
        return node.canAddMixin("publication:stateAndVersionBasedPublication");
    }

    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        String versionName;
        String logItemName = versionName = context.get("Publication.context.currentVersion");
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        Node selectedRevision = null;
        if (node.getName().equals(versionName) || versionName == null) {
            selectedRevision = node;
            logItemName = node.getName();
        } else {
            selectedRevision = node.getVersionHistory().getVersion(versionName);
        }
        Map<String, VersionData> revisionsMap = this.getRevisionData(node);
        VersionLog versionLog = null;
        ValueFactory valueFactory = node.getSession().getValueFactory();
        if ("enrolled".equalsIgnoreCase(newState)) {
            versionLog = new VersionLog(logItemName, newState, node.getSession().getUserID(), GregorianCalendar.getInstance(), "PublicationService.StageAndVersionPublicationPlugin.changeState.enrolled");
            node.setProperty("publication:currentState", newState);
            VersionData revisionData = new VersionData(node.getUUID(), newState, userId);
            revisionsMap.put(node.getUUID(), revisionData);
            this.addRevisionData(node, revisionsMap.values());
            this.addLog(node, versionLog);
        } else if ("draft".equalsIgnoreCase(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, node.getSession().getUserID(), GregorianCalendar.getInstance(), "PublicationService.StageAndVersionPublicationPlugin.changeState.draft");
            this.addLog(node, versionLog);
            VersionData versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("published".equals(newState)) {
            Version liveVersion = node.checkin();
            node.checkout();
            Node oldLiveRevision = this.getLiveRevision(node);
            if (oldLiveRevision != null) {
                VersionData versionData = revisionsMap.get(oldLiveRevision.getUUID());
                if (versionData != null) {
                    versionData.setAuthor(userId);
                    versionData.setState("obsolete");
                } else {
                    versionData = new VersionData(oldLiveRevision.getUUID(), "obsolete", userId);
                }
                revisionsMap.put(oldLiveRevision.getUUID(), versionData);
                versionLog = new VersionLog(oldLiveRevision.getName(), "obsolete", userId, (Calendar)new GregorianCalendar(), "PublicationService.StageAndVersionPublicationPlugin.changeState.obsolete");
                this.addLog(node, versionLog);
            }
            versionLog = new VersionLog(liveVersion.getName(), newState, userId, (Calendar)new GregorianCalendar(), "PublicationService.StageAndVersionPublicationPlugin.changeState.published");
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "published");
            VersionData editableRevision = revisionsMap.get(node.getUUID());
            if (editableRevision != null) {
                editableRevision.setAuthor(userId);
                editableRevision.setState("enrolled");
            } else {
                editableRevision = new VersionData(node.getUUID(), "enrolled", userId);
            }
            revisionsMap.put(node.getUUID(), editableRevision);
            versionLog = new VersionLog(node.getBaseVersion().getName(), "draft", userId, (Calendar)new GregorianCalendar(), "PublicationService.StageAndVersionPublicationPlugin.changeState.enrolled");
            Value liveVersionValue = valueFactory.createValue((Node)liveVersion);
            node.setProperty("publication:liveRevision", liveVersionValue);
            node.setProperty("publication:liveDate", (Calendar)new GregorianCalendar());
            VersionData liveRevisionData = new VersionData(liveVersion.getUUID(), "published", userId);
            revisionsMap.put(liveVersion.getUUID(), liveRevisionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("obsolete".equalsIgnoreCase(newState)) {
            Value value = valueFactory.createValue(selectedRevision);
            Value liveRevision = this.getValue(node, "publication:liveRevision");
            if (liveRevision != null && value.getString().equals(liveRevision.getString())) {
                node.setProperty("publication:liveRevision", (Value)null);
            }
            versionLog = new VersionLog(selectedRevision.getName(), "obsolete", userId, (Calendar)new GregorianCalendar(), "PublicationService.StageAndVersionPublicationPlugin.changeState.obsolete");
            VersionData versionData = revisionsMap.get(selectedRevision.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState("obsolete");
            } else {
                versionData = new VersionData(selectedRevision.getUUID(), "obsolete", userId);
            }
            revisionsMap.put(selectedRevision.getUUID(), versionData);
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "obsolete");
            this.addRevisionData(node, revisionsMap.values());
        }
        if (!node.isNew()) {
            node.save();
        }
        if (!"enrolled".equalsIgnoreCase(newState)) {
            CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
            if ("true".equalsIgnoreCase(context.get("Publication.context.isInitialPhase"))) {
                this.listenerService.broadcast("PublicationService.event.postInitState", (Object)cmsService, (Object)node);
            } else {
                this.listenerService.broadcast("PublicationService.event.postChangeState", (Object)cmsService, (Object)node);
                if (this.activityService.isAcceptedNode(node)) {
                    this.listenerService.broadcast(ActivityCommonService.STATE_CHANGED_ACTIVITY, (Object)node, (Object)newState);
                }
            }
        }
    }

    private Value getValue(Node node, String prop) {
        try {
            return node.getProperty(prop).getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getLiveRevision(Node node) {
        try {
            String nodeVersionUUID = null;
            if (node.hasProperty("publication:liveRevision")) {
                nodeVersionUUID = node.getProperty("publication:liveRevision").getString();
            }
            if (nodeVersionUUID == null && "published".equals(node.getProperty("publication:currentState").getString())) {
                return node;
            }
            return node.getVersionHistory().getSession().getNodeByUUID(nodeVersionUUID);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addLog(Node node, VersionLog versionLog) throws Exception {
        Value[] values = node.getProperty("publication:history").getValues();
        ValueFactory valueFactory = node.getSession().getValueFactory();
        ArrayList<Value> list = new ArrayList<Value>(Arrays.asList(values));
        list.add(valueFactory.createValue(versionLog.toString()));
        node.setProperty("publication:history", list.toArray(new Value[0]));
    }

    private void addRevisionData(Node node, Collection<VersionData> list) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        ValueFactory factory = node.getSession().getValueFactory();
        for (VersionData versionData : list) {
            valueList.add(factory.createValue(versionData.toStringValue()));
        }
        node.setProperty("publication:revisionData", valueList.toArray(new Value[0]));
    }

    private Map<String, VersionData> getRevisionData(Node node) throws Exception {
        HashMap<String, VersionData> map = new HashMap<String, VersionData>();
        try {
            for (Value v : node.getProperty("publication:revisionData").getValues()) {
                VersionData versionData = VersionData.toVersionData(v.getString());
                map.put(versionData.getUUID(), versionData);
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    public String getLocalizedAndSubstituteMessage(Locale locale, String key, String[] values) throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundleService bundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = bundleService.getResourceBundle("locale.services.publication.lifecycle.stageversion.StageAndVersionPublication", locale, cl);
        String result = "";
        try {
            result = resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = key;
        }
        if (values != null) {
            return String.format(result, values);
        }
        return result;
    }

    public Node getNodeView(Node node, Map<String, Object> context) throws Exception {
        WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        String currentState = wcmPublicationService.getContentState(node);
        if ("enrolled".equals(currentState) || "obsolete".equals(currentState)) {
            return null;
        }
        if (context.get("filter-mode").equals("Edit")) {
            return node;
        }
        Node liveNode = this.getLiveRevision(node);
        if (liveNode != null) {
            return liveNode.getNode("jcr:frozenNode");
        }
        return null;
    }

    public String[] getPossibleStates() {
        return new String[]{"enrolled", "draft", "published", "obsolete"};
    }

    public byte[] getStateImage(Node arg0, Locale arg1) throws IOException, FileNotFoundException, Exception {
        return null;
    }

    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIPublicationContainer publicationContainer = (UIPublicationContainer)component.createUIComponent(UIPublicationContainer.class, null, null);
        publicationContainer.initContainer(node);
        return publicationContainer;
    }

    public String getUserInfo(Node arg0, Locale arg1) throws Exception {
        return null;
    }

    private List<String> getRunningPortals(String userId) throws Exception {
        ArrayList<String> listPortalName = new ArrayList<String>();
        DataStorage service = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        LazyPageList pageList = service.find(query);
        UserACL userACL = (UserACL)WCMCoreUtils.getService(UserACL.class);
        for (Object object : pageList.getAll()) {
            PortalConfig portalConfig = (PortalConfig)object;
            if (!userACL.hasPermission(portalConfig)) continue;
            listPortalName.add(portalConfig.getName());
        }
        return listPortalName;
    }

    public List<String> getListUserNavigationUri(Page page, String remoteUser) throws Exception {
        ArrayList<String> listPageNavigationUri = new ArrayList<String>();
        for (String portalName : this.getRunningPortals(remoteUser)) {
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
            UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, remoteUser, PortalRequestContext.USER_PORTAL_CONTEXT);
            UserPortal userPortal = userPortalCfg.getUserPortal();
            List navigationList = userPortal.getNavigations();
            for (UserNavigation nav : navigationList) {
                UserNode root = userPortal.getNode(nav, Scope.ALL, null, null);
                List userNodeList = PublicationUtil.findUserNodeByPageId((UserNode)root, (String)page.getPageId());
                for (UserNode node : userNodeList) {
                    listPageNavigationUri.add(PublicationUtil.setMixedNavigationUri((String)portalName, (String)node.getURI()));
                }
            }
        }
        return listPageNavigationUri;
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser) throws Exception {
        this.updateLifecyleOnChangeContent(node, remoteUser, "draft");
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser, String newState) throws Exception {
        String state = node.getProperty("publication:currentState").getString();
        if (state.equals(newState)) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        this.changeState(node, newState, context);
    }
}

