/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.StringUtils;
import org.chromattic.api.ChromatticSession;
import org.chromattic.common.IO;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.template.plugin.WikiTemplatePagePlugin;
import org.exoplatform.wiki.utils.Utils;

public class JCRDataStorage
implements DataStorage {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private static final int MAX_EXCERPT_LENGTH = 430;
    private WikiTemplatePagePlugin templatePlugin;

    public void setTemplatePagePlugin(WikiTemplatePagePlugin plugin) {
        this.templatePlugin = plugin;
    }

    @Override
    public PageList<SearchResult> search(ChromatticSession session, WikiSearchData data) throws Exception {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        long numberOfSearchForTitleResult = 0L;
        if (!StringUtils.isEmpty((String)data.getTitle())) {
            QueryResult result;
            RowIterator iter;
            String statement = data.getStatementForSearchingTitle();
            QueryImpl q = (QueryImpl)((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
            if (data.getOffset() > 0L) {
                q.setOffset(data.getOffset());
            }
            if (data.getLimit() > 0) {
                q.setLimit((long)data.getLimit());
            }
            if ((numberOfSearchForTitleResult = (iter = (result = q.execute()).getRows()).getSize()) > 0L) {
                while (iter.hasNext()) {
                    SearchResult tempResult = this.getResult(iter.nextRow(), data);
                    if (tempResult == null || this.isContains(resultList, tempResult)) continue;
                    resultList.add(tempResult);
                }
            }
        }
        if (resultList.size() >= data.getLimit() || StringUtils.isEmpty((String)data.getContent())) {
            return new ObjectPageList(resultList, resultList.size());
        }
        long searchForContentOffset = data.getOffset();
        long searchForContentLimit = (long)data.getLimit() - numberOfSearchForTitleResult;
        if (data.getLimit() == Integer.MAX_VALUE) {
            searchForContentLimit = Integer.MAX_VALUE;
        }
        if (searchForContentOffset >= 0L && searchForContentLimit > 0L) {
            String statement = data.getStatementForSearchingContent();
            QueryImpl q = (QueryImpl)((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
            q.setOffset(searchForContentOffset);
            q.setLimit(searchForContentLimit);
            QueryResult result = q.execute();
            RowIterator iter = result.getRows();
            while (iter.hasNext()) {
                SearchResult tempResult = this.getResult(iter.nextRow(), data);
                if (tempResult == null || this.isContains(resultList, tempResult) || this.isDuplicateTitle(resultList, tempResult)) continue;
                resultList.add(tempResult);
            }
        }
        return new ObjectPageList(resultList, resultList.size());
    }

    public boolean isDuplicateTitle(List<SearchResult> list, SearchResult result) {
        for (SearchResult searchResult : list) {
            if (!result.getTitle().equals(searchResult.getTitle())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Page getWikiPageByUUID(ChromatticSession session, String uuid) throws Exception {
        return (Page)session.findById(Page.class, uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultTemplatePage(ChromatticSession crmSession, ConfigurationManager configurationManager, String path) {
        if (this.templatePlugin != null) {
            try {
                Iterator<String> iterator = this.templatePlugin.getSourcePaths().iterator();
                Session session = crmSession.getJCRSession();
                InputStream is = null;
                while (iterator.hasNext()) {
                    try {
                        String sourcePath = iterator.next();
                        is = configurationManager.getInputStream(sourcePath);
                        int type = 0;
                        if (((Node)session.getItem(path)).hasNode("wiki:templatecontainer")) {
                            type = 2;
                        }
                        session.importXML(path, is, type);
                        session.save();
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                log.info((Object)("Failed to init default template page because: " + e.getCause()));
            }
        }
    }

    private SearchResult getResult(Row row, WikiSearchData data) throws Exception {
        String type = row.getValue("jcr:primaryType").getString();
        String path = row.getValue("jcr:path").getString();
        String title = "";
        String excerpt = "";
        long jcrScore = row.getValue("jcr:score").getLong();
        Calendar updateDate = GregorianCalendar.getInstance();
        Calendar createdDate = GregorianCalendar.getInstance();
        PageImpl page = null;
        if ("wiki:attachment".equals(type)) {
            type = "wiki:attachment".toString();
            if (!path.endsWith("content")) {
                AttachmentImpl searchAtt = (AttachmentImpl)Utils.getObject(path, "wiki:attachment");
                updateDate = searchAtt.getUpdatedDate();
                page = searchAtt.getParentPage();
                createdDate.setTime(page.getCreatedDate());
                title = page.getTitle();
            } else {
                String pagePath = path.substring(0, path.lastIndexOf("/content"));
                type = "wiki:content".toString();
                page = (PageImpl)Utils.getObject(pagePath, "wiki:page");
                title = page.getTitle();
                updateDate.setTime(page.getUpdatedDate());
                createdDate.setTime(page.getCreatedDate());
            }
        } else if ("wiki:page".equals(type)) {
            page = (PageImpl)Utils.getObject(path, type);
            updateDate.setTime(page.getUpdatedDate());
            createdDate.setTime(page.getCreatedDate());
            title = page.getTitle();
        } else {
            return null;
        }
        excerpt = this.getExcerpt(row, type);
        if (page == null || !page.hasPermission(PermissionType.VIEWPAGE)) {
            return null;
        }
        SearchResult result = new SearchResult(excerpt, title, path, type, updateDate, createdDate);
        result.setUrl(page.getURL());
        result.setJcrScore(jcrScore);
        return result;
    }

    private String getExcerpt(Row row, String type) throws ItemNotFoundException, RepositoryException {
        String[] properties;
        String[] stringArray;
        StringBuilder ret = new StringBuilder();
        if ("wiki:content".equals(type) || "wiki:attachment".equals(type)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "title";
            stringArray = stringArray3;
            stringArray3[1] = "url";
        }
        for (String prop : properties = stringArray) {
            Value excerptValue = row.getValue("rep:excerpt(" + prop + ")");
            if (excerptValue == null) continue;
            ret.append(excerptValue.getString()).append("...");
        }
        if (ret.length() > 430) {
            return ret.substring(0, 430) + "...";
        }
        return ret.toString();
    }

    @Override
    public List<SearchResult> searchRenamedPage(ChromatticSession session, WikiSearchData data) throws Exception {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        String statement = data.getStatementForRenamedPage();
        Query q = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
        QueryResult result = q.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            try {
                resultList.add(this.getResult(iter.nextNode()));
            }
            catch (Exception e) {
                log.debug((Object)"Failed to add item search result", (Throwable)e);
            }
        }
        return resultList;
    }

    private SearchResult getResult(Node node) throws Exception {
        SearchResult result = new SearchResult();
        result.setPageName(node.getName());
        String title = node.getProperty("title").getString();
        InputStream data = node.getNode("content").getNode("jcr:content").getProperty("jcr:data").getStream();
        byte[] bytes = IO.getBytes((InputStream)data);
        String content = new String(bytes, "UTF-8");
        if (content.length() > 100) {
            content = content.substring(0, 100) + "...";
        }
        result.setExcerpt(content);
        result.setTitle(title);
        return result;
    }

    @Override
    public InputStream getAttachmentAsStream(String path, ChromatticSession session) throws Exception {
        Node attContent = (Node)session.getJCRSession().getItem(path);
        return attContent.getProperty("jcr:data").getStream();
    }

    private boolean isContains(List<SearchResult> list, SearchResult result) throws Exception {
        AttachmentImpl att = null;
        PageImpl page = null;
        if ("wiki:attachment".equals(result.getType())) {
            att = (AttachmentImpl)Utils.getObject(result.getPath(), "wiki:attachment");
        } else if ("nt:resource".equals(result.getType())) {
            String attPath = result.getPath().substring(0, result.getPath().lastIndexOf("/"));
            att = (AttachmentImpl)Utils.getObject(attPath, "wiki:attachment");
        } else if ("wiki:page".equals(result.getType()) || "exo:wikihome".equals(result.getType())) {
            page = (PageImpl)Utils.getObject(result.getPath(), "wiki:page");
        } else if ("wiki:content".equals(result.getType())) {
            att = (AttachmentImpl)Utils.getObject(result.getPath(), "wiki:attachment");
            page = att.getParentPage();
        }
        if (att != null || page != null) {
            Iterator<SearchResult> iter = list.iterator();
            while (iter.hasNext()) {
                SearchResult child = iter.next();
                if ("wiki:attachment".equals(child.getType()) || "wiki:content".equals(child.getType())) {
                    AttachmentImpl tempAtt = (AttachmentImpl)Utils.getObject(child.getPath(), "wiki:attachment");
                    if (att != null && att.equals(tempAtt)) {
                        if (child.getExcerpt() == null && result.getExcerpt() != null) {
                            child.setExcerpt(result.getExcerpt());
                        }
                        return true;
                    }
                    if (page == null || !page.getName().equals(tempAtt.getParentPage())) continue;
                    return true;
                }
                if (!"wiki:page".equals(child.getType()) || page == null || !page.getPath().equals(child.getPath())) continue;
                iter.remove();
                return false;
            }
        }
        return false;
    }

    @Override
    public List<TemplateSearchResult> searchTemplate(ChromatticSession session, TemplateSearchData data) throws Exception {
        ArrayList<TemplateSearchResult> resultList = new ArrayList<TemplateSearchResult>();
        String statement = data.getStatementForSearchingTitle();
        Query q = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
        QueryResult result = q.execute();
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            TemplateSearchResult tempResult = this.getTemplateResult(iter.nextRow());
            resultList.add(tempResult);
        }
        return resultList;
    }

    private TemplateSearchResult getTemplateResult(Row row) throws Exception {
        String type = row.getValue("jcr:primaryType").getString();
        String path = row.getValue("jcr:path").getString();
        String title = row.getValue("title") == null ? null : row.getValue("title").getString();
        Template template = (Template)Utils.getObject(path, "wiki:page");
        String description = template.getDescription();
        TemplateSearchResult result = new TemplateSearchResult(template.getName(), title, path, type, null, null, description);
        return result;
    }
}

