/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.filter;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.filter.FilterLiteral;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.filter.JCRFilterLiteral;
import org.exoplatform.social.core.chromattic.filter.JCRFilterOption;
import org.exoplatform.social.core.chromattic.filter.JCROrderByOption;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;

public class ActivityFilter
extends JCRFilterLiteral {
    private static final Log LOG = ExoLogger.getLogger(ActivityFilter.class);
    private static PropertyLiteralExpression<String> MENTION_TITLE = new PropertyLiteralExpression<String>(String.class, "soc:title");
    private static PropertyLiteralExpression<ActivityStorage.TimestampType> ACTIVITY_UPDATED_POINT = new PropertyLiteralExpression<ActivityStorage.TimestampType>(ActivityStorage.TimestampType.class, ActivityEntity.lastUpdated.toString());
    private static PropertyLiteralExpression<ActivityStorage.TimestampType> ACTIVITY_FROM_UPDATED_POINT = new PropertyLiteralExpression<ActivityStorage.TimestampType>(ActivityStorage.TimestampType.class, "From_Last_Updated");
    private static PropertyLiteralExpression<ActivityStorage.TimestampType> ACTIVITY_TO_UPDATED_POINT = new PropertyLiteralExpression<ActivityStorage.TimestampType>(ActivityStorage.TimestampType.class, "To_Last_Updated");
    public static JCRFilterOption IS_COMMENT_FIELD = new JCRFilterOption(ActivityEntity.isComment);
    public static JCRFilterOption POSTED_TIME_FIELD = new JCRFilterOption(ActivityEntity.postedTime);
    public static JCRFilterOption IDENTITY_FIELD = new JCRFilterOption(ActivityEntity.identity);
    public static JCRFilterOption POSTER_FIELD = new JCRFilterOption(ActivityEntity.poster);
    public static JCRFilterOption TITLE_FIELD = new JCRFilterOption(ActivityEntity.title);
    public static JCRFilterOption MENTIONERS_FIELD = new JCRFilterOption(ActivityEntity.mentioners);
    public static JCRFilterOption COMMENTERS_FIELD = new JCRFilterOption(ActivityEntity.commenters);
    public static JCRFilterOption LIKES_FIELD = new JCRFilterOption(ActivityEntity.likes);
    public static JCRFilterOption TITLE_MENTION_FIELD = new JCRFilterOption((PropertyLiteralExpression)MENTION_TITLE){

        public FilterLiteral<PropertyLiteralExpression<?>> value(Object value) {
            String newValue = null;
            if (((PropertyLiteralExpression)this.getLiteral()).getType() == value.getClass()) {
                newValue = "% @" + value.toString() + " %";
            }
            return super.value(newValue);
        }
    };
    public static JCRFilterOption ACTIVITY_UPDATED_POINT_FIELD = new JCRFilterOption(ACTIVITY_UPDATED_POINT);
    public static JCRFilterOption ACTIVITY_FROM_UPDATED_POINT_FIELD = new JCRFilterOption(ACTIVITY_FROM_UPDATED_POINT);
    public static JCRFilterOption ACTIVITY_TO_UPDATED_POINT_FIELD = new JCRFilterOption(ACTIVITY_TO_UPDATED_POINT);
    public static JCROrderByOption POSTED_TIME_ORDERBY = new JCROrderByOption(ActivityEntity.postedTime);
    public static JCROrderByOption LAST_UPDATED_ORDERBY = new JCROrderByOption(ActivityEntity.lastUpdated);
    public static JCRFilterLiteral ACTIVITY_NEW_UPDATED_FILTER = new JCRFilterLiteral(){

        protected void start() {
            try {
                this.append(ACTIVITY_UPDATED_POINT_FIELD.clone()).with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC);
            }
            catch (Exception ex) {
                LOG.warn((Object)ex);
            }
        }

        public void destroy() {
        }
    };
    public static JCRFilterLiteral ACTIVITY_VIEWED_RANGE_FILTER = new JCRFilterLiteral(){

        protected void start() {
            try {
                this.append(ACTIVITY_FROM_UPDATED_POINT_FIELD.clone()).append(ACTIVITY_TO_UPDATED_POINT_FIELD.clone()).with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC);
            }
            catch (Exception ex) {
                LOG.warn((Object)ex);
            }
        }

        public void destroy() {
        }
    };

    protected void start() {
        try {
            this.append(ACTIVITY_UPDATED_POINT_FIELD.clone()).append(MENTIONERS_FIELD.clone()).append(COMMENTERS_FIELD.clone()).append(LIKES_FIELD.clone()).with((FilterLiteral.FilterOption)IS_COMMENT_FIELD).value((Object)Boolean.FALSE).with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC);
        }
        catch (Exception ex) {
            LOG.warn((Object)ex);
        }
    }

    public void destroy() {
        this.with(ACTIVITY_UPDATED_POINT_FIELD).value(null);
        this.with(MENTIONERS_FIELD).value(null);
        this.with(COMMENTERS_FIELD).value(null);
        this.with(LIKES_FIELD).value(null);
    }

    public static ActivityFilter space() {
        return new ActivityFilter(){

            @Override
            protected void start() {
                try {
                    super.start();
                    this.append(ACTIVITY_UPDATED_POINT_FIELD.clone()).with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC);
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex);
                }
            }
        };
    }

    public static ActivityFilter spaceNewer() {
        return new ActivityFilter(){

            @Override
            protected void start() {
                try {
                    super.start();
                    this.remove(POSTED_TIME_ORDERBY.clone());
                    this.append(ACTIVITY_UPDATED_POINT_FIELD.clone()).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC).with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC);
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex);
                }
            }
        };
    }

    public static ActivityFilter spaceOlder() {
        return new ActivityFilter(){

            @Override
            protected void start() {
                try {
                    super.start();
                    this.remove(POSTED_TIME_ORDERBY);
                    this.append(ACTIVITY_UPDATED_POINT_FIELD.clone()).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC).with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC);
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex);
                }
            }
        };
    }

    public static ActivityFilter newer() {
        return new ActivityFilter(){

            @Override
            protected void start() {
                try {
                    super.start();
                    super.destroy();
                    this.with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.ASC);
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex);
                }
            }
        };
    }

    public static ActivityFilter older() {
        return new ActivityFilter(){

            @Override
            protected void start() {
                try {
                    super.start();
                    super.destroy();
                    this.with(LAST_UPDATED_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC).with(POSTED_TIME_ORDERBY.clone()).direction(FilterLiteral.DIRECTION.DESC);
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex);
                }
            }
        };
    }
}

